/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.mq;

import io.jboot.Jboot;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqConfig;
import io.jboot.components.mq.aliyunmq.JbootAliyunmqImpl;
import io.jboot.components.mq.qpidmq.JbootQpidmqImpl;
import io.jboot.components.mq.rabbitmq.JbootRabbitmqImpl;
import io.jboot.components.mq.redismq.JbootRedismqImpl;
import io.jboot.components.mq.zbus.JbootZbusmqImpl;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.utils.ClassUtil;

public class JbootmqManager {
    private static JbootmqManager manager;
    private Jbootmq jbootmq;

    public static JbootmqManager me() {
        if (manager == null) {
            manager = ClassUtil.singleton(JbootmqManager.class);
        }
        return manager;
    }

    public Jbootmq getJbootmq() {
        if (this.jbootmq == null) {
            JbootmqConfig config = Jboot.config(JbootmqConfig.class);
            this.jbootmq = this.getJbootmq(config);
        }
        return this.jbootmq;
    }

    public Jbootmq getJbootmq(JbootmqConfig config) {
        return this.buildJbootmq(config);
    }

    private Jbootmq buildJbootmq(JbootmqConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        switch (config.getType()) {
            case "redis": {
                return new JbootRedismqImpl();
            }
            case "aliyunmq": {
                return new JbootAliyunmqImpl();
            }
            case "rabbitmq": {
                return new JbootRabbitmqImpl();
            }
            case "zbus": {
                return new JbootZbusmqImpl();
            }
            case "qpid": {
                return new JbootQpidmqImpl();
            }
            case "activemq": {
                throw new RuntimeException("not finished!!!!");
            }
        }
        return JbootSpiLoader.load(Jbootmq.class, config.getType());
    }
}

