/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter;

import com.google.common.util.concurrent.RateLimiter;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.components.limiter.LimitConfig;
import io.jboot.components.limiter.LimitFallbackProcesser;
import io.jboot.components.limiter.LimitFallbackProcesserDefault;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LimiterManager {
    private Set<String> configPackageOrTargets = new HashSet<String>();
    private Map<String, TypeAndRate> typeAndRateCache = new HashMap<String, TypeAndRate>();
    private Map<String, Semaphore> semaphoreCache = new ConcurrentHashMap<String, Semaphore>();
    private Map<String, RateLimiter> rateLimiterCache = new ConcurrentHashMap<String, RateLimiter>();
    private Boolean enable;
    private LimitFallbackProcesser fallbackProcesser;
    private static LimiterManager me = new LimiterManager();

    private LimiterManager() {
    }

    public static LimiterManager me() {
        return me;
    }

    public void init() {
        this.doInitFallbackProcesser();
        this.doParseConfig();
    }

    private void doInitFallbackProcesser() {
        LimitConfig config = Jboot.config(LimitConfig.class);
        this.fallbackProcesser = StrUtil.isBlank((String)config.getFallbackProcesser()) ? new LimitFallbackProcesserDefault() : (LimitFallbackProcesser)Objects.requireNonNull(ClassUtil.newInstance(config.getFallbackProcesser()), "can not newInstance class for " + config.getFallbackProcesser());
    }

    private void doParseConfig() {
        String[] rules;
        LimitConfig config = Jboot.config(LimitConfig.class);
        if (!this.isEnable()) {
            return;
        }
        String rule = config.getRule();
        if (StrUtil.isBlank((String)rule)) {
            return;
        }
        for (String r : rules = rule.split(",")) {
            String rate;
            String type;
            String packageOrTarget;
            String[] confs = r.split(":");
            if (confs == null || confs.length != 3 || !this.ensureLegal(packageOrTarget = confs[0], type = confs[1], (rate = confs[2]).trim())) continue;
            packageOrTarget = packageOrTarget.replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("*", ".*");
            this.configPackageOrTargets.add(packageOrTarget.trim());
            this.typeAndRateCache.put(packageOrTarget.trim(), new TypeAndRate(type.trim(), Integer.valueOf(rate.trim())));
        }
    }

    public TypeAndRate matchConfig(String packageOrTarget) {
        if (!this.isEnable() || this.configPackageOrTargets.isEmpty()) {
            return null;
        }
        for (String configPackageOrTarget : this.configPackageOrTargets) {
            if (!LimiterManager.match(packageOrTarget, configPackageOrTarget)) continue;
            return this.typeAndRateCache.get(configPackageOrTarget);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimiter getOrCreateRateLimiter(String resource, int rate) {
        RateLimiter limiter = this.rateLimiterCache.get(resource);
        if (limiter == null || limiter.getRate() != (double)rate) {
            String string = resource;
            synchronized (string) {
                limiter = this.rateLimiterCache.get(resource);
                if (limiter == null) {
                    limiter = RateLimiter.create((double)rate);
                    this.rateLimiterCache.put(resource, limiter);
                }
            }
        }
        return limiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Semaphore getOrCreateSemaphore(String resource, int rate) {
        Semaphore semaphore = this.semaphoreCache.get(resource);
        if (semaphore == null) {
            String string = resource;
            synchronized (string) {
                semaphore = this.semaphoreCache.get(resource);
                if (semaphore == null) {
                    semaphore = new Semaphore(rate);
                    this.semaphoreCache.put(resource, semaphore);
                }
            }
        }
        return semaphore;
    }

    private static boolean match(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private boolean ensureLegal(String packageOrTarget, String type, String rate) {
        if (StrUtil.isBlank((String)packageOrTarget)) {
            return false;
        }
        if (!"cc".equals(type) && !"tb".equals(type)) {
            return false;
        }
        return StrUtil.isNumeric(rate);
    }

    public boolean isEnable() {
        if (this.enable == null) {
            this.enable = Jboot.config(LimitConfig.class).isEnable();
        }
        return this.enable;
    }

    public void processFallback(String resource, String fallback, Invocation inv) {
        this.fallbackProcesser.process(resource, fallback, inv);
    }

    public static class TypeAndRate {
        private String type;
        private int rate;

        public TypeAndRate(String type, int rate) {
            this.type = type;
            this.rate = rate;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getRate() {
            return this.rate;
        }

        public void setRate(int rate) {
            this.rate = rate;
        }
    }
}

