/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import com.jfinal.log.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class JbootHttpResponse {
    private static final Log log = Log.getLog(JbootHttpResponse.class);
    private String content;
    private OutputStream outputStream;
    private File file;
    private Throwable error;
    private Map<String, List<String>> headers;
    private int responseCode;
    private String contentType;

    public JbootHttpResponse() {
        this.outputStream = new ByteArrayOutputStream();
    }

    public JbootHttpResponse(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            this.file = file;
            this.outputStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        if (this.outputStream != null && this.outputStream instanceof ByteArrayOutputStream) {
            return new String(((ByteArrayOutputStream)this.outputStream).toByteArray());
        }
        return null;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void pipe(InputStream inputStream) {
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                this.outputStream.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.toString(), throwable);
            this.setError(throwable);
        }
    }

    public void finish() {
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isNotError() {
        return !this.isError();
    }

    public boolean isError() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

