/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import io.jboot.utils.StrUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class JbootHttpRequest {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_TRACE = "TRACE";
    public static final int READ_TIME_OUT = 10000;
    public static final int CONNECT_TIME_OUT = 5000;
    public static final String CHAR_SET = "UTF-8";
    public static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_URL_ENCODED = "application/x-www-form-urlencoded;charset=utf-8";
    Map<String, String> headers;
    Map<String, Object> params;
    private String requestUrl;
    private String certPath;
    private String certPass;
    private String method = "GET";
    private int readTimeOut = 10000;
    private int connectTimeOut = 5000;
    private String charset = "UTF-8";
    private boolean multipartFormData = false;
    private File downloadFile;
    private String contentType = "application/x-www-form-urlencoded;charset=utf-8";
    private String postContent;

    public static JbootHttpRequest create(String url) {
        return new JbootHttpRequest(url);
    }

    public static JbootHttpRequest create(String url, String method) {
        JbootHttpRequest request = new JbootHttpRequest(url);
        request.setMethod(method);
        return request;
    }

    public static JbootHttpRequest create(String url, Map<String, Object> params) {
        JbootHttpRequest request = new JbootHttpRequest(url);
        request.setParams(params);
        return request;
    }

    public static JbootHttpRequest create(String url, Map<String, Object> params, String method) {
        JbootHttpRequest request = new JbootHttpRequest(url);
        request.setMethod(method);
        request.setParams(params);
        return request;
    }

    public JbootHttpRequest() {
    }

    public JbootHttpRequest(String url) {
        this.requestUrl = url;
    }

    public void addParam(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        if (value instanceof File) {
            this.setMultipartFormData(true);
        }
        this.params.put(key, value);
    }

    public void addParams(Map<String, Object> map) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof File) {
                this.setMultipartFormData(true);
            }
            this.params.put(entry.getKey(), entry.getValue());
        }
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.putAll(headers);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof File)) continue;
            this.setMultipartFormData(true);
        }
        this.params = params;
    }

    public boolean isPostRequest() {
        return METHOD_POST.equalsIgnoreCase(this.method);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isMultipartFormData() {
        return this.multipartFormData;
    }

    public void setMultipartFormData(boolean multipartFormData) {
        this.multipartFormData = multipartFormData;
    }

    public File getDownloadFile() {
        return this.downloadFile;
    }

    public void setDownloadFile(File downloadFile) {
        this.downloadFile = downloadFile;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getPostContent() {
        if (this.postContent != null) {
            this.initGetUrl();
            return this.postContent;
        }
        return this.buildParams();
    }

    public void setPostContent(String postContent) {
        this.postContent = postContent;
    }

    private String buildParams() {
        Map<String, Object> params = this.getParams();
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getKey() == null || !StrUtil.isNotBlank(entry.getValue())) continue;
            try {
                builder.append(entry.getKey().trim()).append("=").append(URLEncoder.encode(entry.getValue().toString(), this.getCharset())).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (builder.charAt(builder.length() - 1) == '&') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public void initGetUrl() {
        String params = this.buildParams();
        if (StrUtil.isBlank((String)params)) {
            return;
        }
        String originUrl = this.getRequestUrl();
        originUrl = originUrl.contains("?") ? originUrl + "&" + params : originUrl + "?" + params;
        this.setRequestUrl(originUrl);
    }
}

