/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.j2cache;

import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.components.cache.JbootCache;
import io.jboot.exception.JbootException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.J2Cache;

public class J2cacheImpl
implements JbootCache {
    @Override
    public <T> T get(String cacheName, Object key) {
        CacheObject cacheObject = J2Cache.getChannel().get(cacheName, key.toString(), new boolean[]{false});
        return (T)(cacheObject != null ? cacheObject.getValue() : null);
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        J2Cache.getChannel().set(cacheName, key.toString(), value);
    }

    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        J2Cache.getChannel().set(cacheName, key.toString(), value, (long)liveSeconds);
    }

    @Override
    public List getKeys(String cacheName) {
        Collection keys = J2Cache.getChannel().keys(cacheName);
        return keys != null ? new ArrayList(keys) : null;
    }

    @Override
    public void remove(String cacheName, Object key) {
        J2Cache.getChannel().evict(cacheName, new String[]{key.toString()});
    }

    @Override
    public void removeAll(String cacheName) {
        J2Cache.getChannel().clear(cacheName);
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object value = this.get(cacheName, key);
        if (value == null && (value = dataLoader.load()) != null) {
            this.put(cacheName, key, value);
        }
        return value;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        throw new JbootException("getTtl not support in j2cache");
    }

    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        throw new JbootException("setTtl not support in j2cache");
    }
}

