/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

class Utils {
    private static String rootClassPath;

    Utils() {
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public static boolean isNotBlank(String string) {
        return !Utils.isBlank(string);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Method> getClassSetMethods(Class clazz) {
        Method[] methods;
        ArrayList<Method> setMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().startsWith("set") || method.getName().length() <= 3 || method.getParameterCount() != 1) continue;
            setMethods.add(method);
        }
        return setMethods;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String getRootClassPath() {
        if (rootClassPath == null) {
            try {
                String path = Utils.getClassLoader().getResource("").toURI().getPath();
                rootClassPath = new File(path).getAbsolutePath();
            }
            catch (Exception e) {
                try {
                    String path = Utils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    path = URLDecoder.decode(path, "UTF-8");
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    rootClassPath = path;
                }
                catch (UnsupportedEncodingException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return rootClassPath;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : Utils.class.getClassLoader();
    }

    public static void doNothing(Throwable ex) {
    }

    public static final Object convert(Class<?> type, String s) {
        if (type == String.class) {
            return s;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(s);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(s);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(s);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            String value = s.toLowerCase();
            if ("1".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("0".equals(value) || "false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: " + s);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (type == BigInteger.class) {
            return new BigInteger(s);
        }
        if (type == byte[].class) {
            return s.getBytes();
        }
        throw new RuntimeException(type.getName() + " can not be converted, please use other type in your config class!");
    }
}

