/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import io.jboot.app.config.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

class Prop {
    protected Properties properties = null;
    private static final String DEFAULT_ENCODING = "UTF-8";

    public Prop(String fileName) {
        this(fileName, DEFAULT_ENCODING);
    }

    public Prop(String fileName, String encoding) {
        InputStream inputStream = null;
        try {
            inputStream = Utils.getClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new IllegalArgumentException("properties file not found in classpath,  fileName : " + fileName);
            }
            this.properties = new Properties();
            this.properties.load(new InputStreamReader(inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException("error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

