/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import com.jfinal.server.undertow.UndertowServer;
import com.jfinal.server.undertow.WebBuilder;
import io.jboot.app.Banner;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.JbootResourceLoader;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.undertow.JbootUndertowConfig;
import io.jboot.app.undertow.JbootUndertowServer;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.DispatcherType;

public class JbootApplication {
    public static void main(String[] args) {
        JbootApplication.run(args);
    }

    public static void run(String[] args) {
        JbootApplication.start(JbootApplication.createServer(args));
    }

    public static void start(UndertowServer server) {
        server.start();
        if (JbootApplication.isDevMode()) {
            new JbootResourceLoader().start();
        }
    }

    public static UndertowServer createServer(String[] args) {
        JbootConfigManager.me().parseArgs(args);
        JbootApplicationConfig appConfig = JbootApplication.getConfig(JbootApplicationConfig.class);
        JbootApplication.printBannerInfo(appConfig);
        JbootApplication.printApplicationInfo(appConfig);
        JbootApplication.printClassPath();
        JbootUndertowConfig undertowConfig = new JbootUndertowConfig(appConfig.getJfinalConfig());
        undertowConfig.addSystemClassPrefix("io.jboot.app");
        undertowConfig.addHotSwapClassPrefix("io.jboot");
        return new JbootUndertowServer(undertowConfig).setDevMode(JbootApplication.isDevMode()).configWeb(webBuilder -> {
            JbootApplication.tryAddMetricsSupport(webBuilder);
            JbootApplication.tryAddShiroSupport(webBuilder);
            JbootApplication.tryAddWebSocketSupport(webBuilder);
        });
    }

    private static void tryAddMetricsSupport(WebBuilder webBuilder) {
        String url = JbootApplication.getConfigValue("jboot.metric.url");
        String reporter = JbootApplication.getConfigValue("jboot.metric.reporter");
        if (url != null && reporter != null) {
            webBuilder.addServlet("MetricsAdminServlet", "com.codahale.metrics.servlets.AdminServlet").addServletMapping("MetricsAdminServlet", url.endsWith("/*") ? url : url + "/*");
            webBuilder.addListener("io.jboot.support.metric.JbootMetricServletContextListener");
            webBuilder.addListener("io.jboot.support.metric.JbootHealthCheckServletContextListener");
        }
    }

    private static void tryAddShiroSupport(WebBuilder webBuilder) {
        String iniConfig = JbootApplication.getConfigValue("jboot.shiro.ini");
        if (iniConfig != null) {
            String urlMapping = JbootApplication.getConfigValue("jboot.shiro.urlMapping");
            if (urlMapping == null) {
                urlMapping = "/*";
            }
            webBuilder.addListener("org.apache.shiro.web.env.EnvironmentLoaderListener");
            webBuilder.addFilter("shiro", "io.jboot.support.shiro.JbootShiroFilter").addFilterUrlMapping("shiro", urlMapping, DispatcherType.REQUEST);
        }
    }

    private static void tryAddWebSocketSupport(WebBuilder webBuilder) {
        String websocketEndpoint = JbootApplication.getConfigValue("jboot.web.webSocketEndpoint");
        if (websocketEndpoint != null && websocketEndpoint.trim().length() > 0) {
            String[] classStrings;
            for (String c : classStrings = websocketEndpoint.split(",")) {
                webBuilder.addWebSocketEndpoint(c);
            }
        }
    }

    private static void printBannerInfo(JbootApplicationConfig appConfig) {
        if (appConfig.isBannerEnable()) {
            System.out.println();
            System.out.println(Banner.getText(appConfig.getBannerFile()));
            System.out.println();
        }
    }

    private static void printApplicationInfo(JbootApplicationConfig appConfig) {
        System.out.println(appConfig.toString());
    }

    private static void printClassPath() {
        try {
            URL resourceURL = JbootApplication.class.getResource("/");
            if (resourceURL != null) {
                System.out.println("Classpath : " + resourceURL.toURI().getPath());
            } else {
                System.out.println("Classpath : application in one jar.");
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static <T> T getConfig(Class<T> clazz) {
        return JbootConfigManager.me().get(clazz);
    }

    private static String getConfigValue(String key) {
        return JbootConfigManager.me().getConfigValue(key);
    }

    public static void setBootArg(String key, Object value) {
        JbootConfigManager.me().setBootArg(key, value);
    }

    private static boolean isDevMode() {
        return JbootConfigManager.me().isDevMode();
    }
}

