/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop.interceptor.cache;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.aop.interceptor.cache.Utils;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.annotation.CachePut;
import io.jboot.utils.AnnotationUtil;
import java.lang.reflect.Method;

public class JbootCachePutInterceptor
implements Interceptor {
    private static final JbootCacheConfig CONFIG = Jboot.config(JbootCacheConfig.class);

    public void intercept(Invocation inv) {
        inv.invoke();
        Method method = inv.getMethod();
        CachePut cachePut = method.getAnnotation(CachePut.class);
        if (cachePut == null) {
            return;
        }
        Object data = inv.getReturnValue();
        String unless = AnnotationUtil.get(cachePut.unless());
        if (Utils.isUnless(unless, method, inv.getArgs())) {
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cachePut.name());
        Utils.ensureCachenameAvailable(method, targetClass, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cachePut.key()), targetClass, method, inv.getArgs());
        this.putDataToCache(cachePut, cacheName, cacheKey, data);
    }

    protected void putDataToCache(CachePut cachePut, String cacheName, String cacheKey, Object data) {
        int liveSeconds;
        int n = liveSeconds = cachePut.liveSeconds() > 0 ? cachePut.liveSeconds() : CONFIG.getAopCacheLiveSeconds();
        if (liveSeconds > 0) {
            Jboot.getCache().put(cacheName, cacheKey, data, liveSeconds);
        } else {
            Jboot.getCache().put(cacheName, cacheKey, data);
        }
    }
}

