/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop.interceptor.cache;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.aop.interceptor.cache.Utils;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.annotation.Cacheable;
import io.jboot.utils.AnnotationUtil;
import java.lang.reflect.Method;

public class JbootCacheInterceptor
implements Interceptor {
    private static final String NULL_VALUE = "NULL_VALUE";
    private static final JbootCacheConfig CONFIG = Jboot.config(JbootCacheConfig.class);

    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        Cacheable cacheable = method.getAnnotation(Cacheable.class);
        if (cacheable == null) {
            inv.invoke();
            return;
        }
        String unlessString = AnnotationUtil.get(cacheable.unless());
        if (Utils.isUnless(unlessString, method, inv.getArgs())) {
            inv.invoke();
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cacheable.name());
        Utils.ensureCachenameAvailable(method, targetClass, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cacheable.key()), targetClass, method, inv.getArgs());
        Object data = Jboot.getCache().get(cacheName, cacheKey);
        if (data != null) {
            if (NULL_VALUE.equals(data)) {
                inv.setReturnValue(null);
            } else {
                inv.setReturnValue(data);
            }
            return;
        }
        inv.invoke();
        data = inv.getReturnValue();
        if (data != null) {
            this.putDataToCache(cacheable, cacheName, cacheKey, data);
        } else if (cacheable.nullCacheEnable()) {
            this.putDataToCache(cacheable, cacheName, cacheKey, NULL_VALUE);
        }
    }

    protected void putDataToCache(Cacheable cacheable, String cacheName, String cacheKey, Object data) {
        int liveSeconds;
        int n = liveSeconds = cacheable.liveSeconds() > 0 ? cacheable.liveSeconds() : CONFIG.getAopCacheLiveSeconds();
        if (liveSeconds > 0) {
            Jboot.getCache().put(cacheName, cacheKey, data, liveSeconds);
        } else {
            Jboot.getCache().put(cacheName, cacheKey, data);
        }
    }
}

