/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.oracle.BlobChunkList;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.parser.SelectLobParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TransactionalBuffer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalBuffer.class);
    private final OracleConnectorConfig connectorConfig;
    private final Map<String, Transaction> transactions = new HashMap<String, Transaction>();
    private final OracleDatabaseSchema schema;
    private final Clock clock;
    private final ErrorHandler errorHandler;
    private final Set<String> abandonedTransactionIds;
    private final Set<String> rolledBackTransactionIds;
    private final Set<RecentlyCommittedTransaction> recentlyCommittedTransactionIds;
    private final Set<Scn> recentlyEmittedDdls;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private Scn lastCommittedScn;
    private Scn maxCommittedScn;

    TransactionalBuffer(OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema, Clock clock, ErrorHandler errorHandler, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.clock = clock;
        this.errorHandler = errorHandler;
        this.lastCommittedScn = Scn.NULL;
        this.maxCommittedScn = Scn.NULL;
        this.abandonedTransactionIds = new HashSet<String>();
        this.rolledBackTransactionIds = new HashSet<String>();
        this.recentlyCommittedTransactionIds = new HashSet<RecentlyCommittedTransaction>();
        this.recentlyEmittedDdls = new HashSet<Scn>();
        this.streamingMetrics = streamingMetrics;
    }

    Set<String> getRolledBackTransactionIds() {
        return new HashSet<String>(this.rolledBackTransactionIds);
    }

    void registerDdlOperation(Scn scn) {
        if (this.connectorConfig.isLobEnabled()) {
            this.recentlyEmittedDdls.add(scn);
        }
    }

    boolean isDdlOperationRegistered(Scn scn) {
        return this.recentlyEmittedDdls.contains(scn);
    }

    void registerDmlOperation(int operation, String transactionId, Scn scn, TableId tableId, Supplier<LogMinerDmlEntry> entrySupplier, Instant changeTime, String rowId, Object rsId) {
        if (this.registerEvent(transactionId, scn, changeTime, () -> new DmlEvent(operation, (LogMinerDmlEntry)entrySupplier.get(), scn, tableId, rowId, rsId))) {
            this.streamingMetrics.incrementRegisteredDmlCount();
        }
    }

    void registerSelectLobOperation(int operation, String transactionId, Scn scn, TableId tableId, Instant changeTime, String rowId, Object rsId, String segOwner, String tableName, String redoSql, Table table, SelectLobParser selectLobParser) {
        this.registerEvent(transactionId, scn, changeTime, () -> {
            LogMinerDmlEntry entry = selectLobParser.parse(redoSql, table);
            entry.setObjectOwner(segOwner);
            entry.setObjectName(tableName);
            return new SelectLobLocatorEvent(operation, entry, selectLobParser.getColumnName(), selectLobParser.isBinary(), scn, tableId, rowId, rsId);
        });
    }

    void registerLobWriteOperation(int operation, String transactionId, Scn scn, TableId tableId, String data, Instant changeTime, String rowId, Object rsId) {
        if (data != null) {
            this.registerEvent(transactionId, scn, changeTime, () -> new LobWriteEvent(operation, this.parseLobWriteSql(data), scn, tableId, rowId, rsId));
        }
    }

    void registerLobEraseOperation(int operation, String transactionId, Scn scn, TableId tableId, Instant changeTime, String rowId, Object rsId) {
        this.registerEvent(transactionId, scn, changeTime, () -> new LobEraseEvent(operation, scn, tableId, rowId, rsId));
    }

    void undoDmlOperation(String transactionId, String undoRowId, TableId tableId) {
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction == null) {
            LOGGER.warn("Cannot undo changes to {} with row id {} as transaction {} not found.", new Object[]{tableId, undoRowId, transactionId});
            return;
        }
        transaction.events.removeIf(o -> {
            if (o.getRowId().equals(undoRowId)) {
                LOGGER.trace("Undoing change to {} with row id {} in transaction {}", new Object[]{tableId, undoRowId, transactionId});
                return true;
            }
            return false;
        });
    }

    void registerTransaction(String transactionId, Scn scn) {
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction == null && !this.isRecentlyCommitted(transactionId)) {
            this.transactions.put(transactionId, new Transaction(transactionId, scn));
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
        } else if (transaction != null && !this.isRecentlyCommitted(transactionId)) {
            LOGGER.trace("Transaction {} is not yet committed and START event detected, reset eventIds.", (Object)transactionId);
            transaction.eventIds = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean commit(String transactionId, Scn scn, OracleOffsetContext offsetContext, Timestamp timestamp, ChangeEventSource.ChangeEventSourceContext context, String debugMessage, EventDispatcher<TableId> dispatcher) {
        Instant start = Instant.now();
        Transaction transaction = this.transactions.remove(transactionId);
        if (transaction == null) {
            return false;
        }
        Scn smallestScn = this.calculateSmallestScn();
        this.abandonedTransactionIds.remove(transactionId);
        if (this.isRecentlyCommitted(transactionId)) {
            return false;
        }
        if (offsetContext.getCommitScn() != null && offsetContext.getCommitScn().compareTo(scn) > 0 || this.lastCommittedScn.compareTo(scn) > 0) {
            LOGGER.debug("Transaction {} already processed, ignored. Committed SCN in offset is {}, commit SCN of the transaction is {}, last committed SCN is {}", new Object[]{transactionId, offsetContext.getCommitScn(), scn, this.lastCommittedScn});
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
            return false;
        }
        this.reconcileTransaction(transaction);
        LOGGER.trace("COMMIT, {}, smallest SCN: {}", (Object)debugMessage, (Object)smallestScn);
        try {
            int counter = transaction.events.size();
            for (LogMinerEvent event : transaction.events) {
                if (!context.isRunning()) {
                    boolean bl = false;
                    return bl;
                }
                if (smallestScn == null || scn.compareTo(smallestScn) < 0) {
                    offsetContext.setScn(event.getScn());
                    this.streamingMetrics.setOldestScn(event.getScn());
                }
                offsetContext.setTransactionId(transaction.transactionId);
                offsetContext.setSourceTime(timestamp.toInstant());
                offsetContext.setTableId(event.getTableId());
                if (--counter == 0) {
                    offsetContext.setCommitScn(scn);
                }
                LOGGER.trace("Processing event {}", (Object)event);
                dispatcher.dispatchDataChangeEvent((DataCollectionId)event.getTableId(), (ChangeRecordEmitter)new LogMinerChangeRecordEmitter(offsetContext, event.getOperation(), event.getEntry().getOldValues(), event.getEntry().getNewValues(), this.schema.tableFor(event.getTableId()), this.clock));
            }
            this.lastCommittedScn = Scn.valueOf(scn.longValue());
            if (!transaction.events.isEmpty()) {
                dispatcher.dispatchTransactionCommittedEvent((OffsetContext)offsetContext);
            } else {
                dispatcher.dispatchHeartbeatEvent((OffsetContext)offsetContext);
            }
            this.streamingMetrics.calculateLagMetrics(timestamp.toInstant());
            if (this.lastCommittedScn.compareTo(this.maxCommittedScn) > 0) {
                LOGGER.trace("Updated transaction buffer max commit SCN to '{}'", (Object)this.lastCommittedScn);
                this.maxCommittedScn = this.lastCommittedScn;
            }
            if (this.connectorConfig.isLobEnabled()) {
                this.recentlyCommittedTransactionIds.add(new RecentlyCommittedTransaction(transaction, scn));
            }
        }
        catch (InterruptedException e) {
            LogMinerHelper.logError(this.streamingMetrics, "Commit interrupted", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
        finally {
            this.streamingMetrics.incrementCommittedTransactions();
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
            this.streamingMetrics.incrementCommittedDmlCount(transaction.events.size());
            this.streamingMetrics.setCommittedScn(scn);
            this.streamingMetrics.setOffsetScn(offsetContext.getScn());
            this.streamingMetrics.setLastCommitDuration(Duration.between(start, Instant.now()));
        }
        return true;
    }

    Scn updateOffsetContext(OracleOffsetContext offsetContext, EventDispatcher<TableId> dispatcher) throws InterruptedException {
        if (this.transactions.isEmpty()) {
            if (!this.maxCommittedScn.isNull()) {
                LOGGER.trace("Transaction buffer is empty, updating offset SCN to '{}'", (Object)this.maxCommittedScn);
                offsetContext.setScn(this.maxCommittedScn);
                dispatcher.dispatchHeartbeatEvent((OffsetContext)offsetContext);
            } else {
                LOGGER.trace("No max committed SCN detected, offset SCN still '{}'", (Object)offsetContext.getScn());
            }
        } else {
            Scn minStartScn = this.getMinimumScn();
            if (!minStartScn.isNull()) {
                LOGGER.trace("Removing all commits up to SCN '{}'", (Object)minStartScn);
                this.recentlyCommittedTransactionIds.removeIf(t -> ((RecentlyCommittedTransaction)t).firstScn.compareTo(minStartScn) < 0);
                LOGGER.trace("Removing all tracked DDL operations up to SCN '{}'", (Object)minStartScn);
                this.recentlyEmittedDdls.removeIf(scn -> scn.compareTo(minStartScn) < 0);
                offsetContext.setScn(minStartScn.subtract(Scn.valueOf(1)));
                dispatcher.dispatchHeartbeatEvent((OffsetContext)offsetContext);
            } else {
                LOGGER.trace("Minimum SCN in transaction buffer is still SCN '{}'", (Object)minStartScn);
            }
        }
        return offsetContext.getScn();
    }

    Scn getMinimumScn() {
        return this.transactions.values().stream().map(t -> ((Transaction)t).firstScn).min(Scn::compareTo).orElse(Scn.NULL);
    }

    boolean rollback(String transactionId, String debugMessage) {
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            LOGGER.debug("Transaction rolled back: {}", (Object)debugMessage);
            this.transactions.remove(transactionId);
            this.abandonedTransactionIds.remove(transactionId);
            this.rolledBackTransactionIds.add(transactionId);
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
            this.streamingMetrics.incrementRolledBackTransactions();
            this.streamingMetrics.addRolledBackTransactionId(transactionId);
            return true;
        }
        return false;
    }

    void abandonLongTransactions(Scn thresholdScn, OracleOffsetContext offsetContext) {
        LogMinerHelper.logWarn(this.streamingMetrics, "All transactions with first SCN <= {} will be abandoned, offset: {}", thresholdScn, offsetContext.getScn());
        Scn threshold = Scn.valueOf(thresholdScn.toString());
        Scn smallestScn = this.calculateSmallestScn();
        if (smallestScn == null) {
            return;
        }
        if (threshold.compareTo(smallestScn) < 0) {
            threshold = smallestScn;
        }
        Iterator<Map.Entry<String, Transaction>> iter = this.transactions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Transaction> transaction = iter.next();
            if (transaction.getValue().firstScn.compareTo(threshold) > 0) continue;
            LogMinerHelper.logWarn(this.streamingMetrics, "Following long running transaction {} will be abandoned and ignored: {} ", transaction.getKey(), transaction.getValue().toString());
            this.abandonedTransactionIds.add(transaction.getKey());
            iter.remove();
            this.streamingMetrics.addAbandonedTransactionId(transaction.getKey());
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
        }
    }

    boolean isTransactionRegistered(String txId) {
        return this.transactions.get(txId) != null;
    }

    private Scn calculateSmallestScn() {
        Scn scn = this.transactions.isEmpty() ? null : this.transactions.values().stream().map(transaction -> ((Transaction)transaction).firstScn).min(Scn::compareTo).orElseThrow(() -> new DataException("Cannot calculate smallest SCN"));
        this.streamingMetrics.setOldestScn(scn == null ? Scn.valueOf(-1) : scn);
        return scn;
    }

    boolean isEmpty() {
        return this.transactions.isEmpty();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.transactions.values().forEach(t -> result.append(t.toString()));
        return result.toString();
    }

    @Override
    public void close() {
        this.transactions.clear();
    }

    private boolean registerEvent(String transactionId, Scn scn, Instant changeTime, Supplier<LogMinerEvent> supplier) {
        if (this.abandonedTransactionIds.contains(transactionId)) {
            LogMinerHelper.logWarn(this.streamingMetrics, "Event for abandoned transaction {}, ignored.", transactionId);
            return false;
        }
        if (this.rolledBackTransactionIds.contains(transactionId)) {
            LogMinerHelper.logWarn(this.streamingMetrics, "Event for rolled back transaction {}, ignored.", transactionId);
            return false;
        }
        if (this.isRecentlyCommitted(transactionId)) {
            LOGGER.trace("Event for transaction {} skipped, transaction already committed.", (Object)transactionId);
            return false;
        }
        Transaction transaction = this.transactions.computeIfAbsent(transactionId, s -> new Transaction(transactionId, scn));
        this.streamingMetrics.setActiveTransactions(this.transactions.size());
        int eventId = transaction.eventIds++;
        if (transaction.events.size() > eventId) {
            return false;
        }
        LOGGER.trace("Transaction {}, adding event reference at index {}", (Object)transactionId, (Object)eventId);
        transaction.events.add(supplier.get());
        this.streamingMetrics.calculateLagMetrics(changeTime);
        return true;
    }

    private boolean isRecentlyCommitted(String transactionId) {
        if (this.recentlyCommittedTransactionIds.isEmpty()) {
            return false;
        }
        for (RecentlyCommittedTransaction transaction : this.recentlyCommittedTransactionIds) {
            if (!transaction.transactionId.equals(transactionId)) continue;
            return true;
        }
        return false;
    }

    private String parseLobWriteSql(String sql) {
        if (sql == null) {
            return null;
        }
        int start = sql.indexOf(":= '");
        if (start != -1) {
            int end = sql.lastIndexOf("'");
            return sql.substring(start + 4, end);
        }
        start = sql.indexOf(":= HEXTORAW");
        if (start != -1) {
            int end = sql.lastIndexOf("'") + 2;
            return sql.substring(start + 3, end);
        }
        throw new DebeziumException("Unable to parse unsupported LOB_WRITE SQL: " + sql);
    }

    private void reconcileTransaction(Transaction transaction) {
        if (!this.connectorConfig.isLobEnabled()) {
            return;
        }
        LOGGER.trace("Reconciling transaction {}", (Object)transaction.transactionId);
        LogMinerEvent prevEvent = null;
        int prevEventSize = transaction.events.size();
        int i = 0;
        block4: while (i < transaction.events.size()) {
            LogMinerEvent event = (LogMinerEvent)transaction.events.get(i);
            LOGGER.trace("Processing event {}", (Object)event);
            switch (event.getOperation()) {
                case 9: {
                    if (!this.shouldMergeSelectLobLocatorEvent(transaction, i, (SelectLobLocatorEvent)event, prevEvent)) break;
                    continue block4;
                }
                case 1: 
                case 3: {
                    if (!this.shouldMergeDmlEvent(transaction, i, (DmlEvent)event, prevEvent)) break;
                    continue block4;
                }
            }
            ++i;
            prevEvent = event;
            LOGGER.trace("Previous event is now {}", (Object)prevEvent);
        }
        if (transaction.events.size() != prevEventSize) {
            LOGGER.trace("Reconciled transaction {} from {} events to {}.", new Object[]{transaction.transactionId, prevEventSize, transaction.events.size()});
        } else {
            LOGGER.trace("Transaction {} event queue was unmodified.", (Object)transaction.transactionId);
        }
    }

    private boolean shouldMergeSelectLobLocatorEvent(Transaction transaction, int index, SelectLobLocatorEvent event, LogMinerEvent prevEvent) {
        int lobEraseEvents;
        LOGGER.trace("\tDetected SelectLobLocatorEvent for column '{}'", (Object)event.getColumnName());
        int columnIndex = LogMinerHelper.getColumnIndexByName(event.getColumnName(), this.schema.tableFor(event.getTableId()));
        Object lobData = null;
        List<String> lobWrites = this.readAndCombineLobWriteEvents(transaction, index, event.isBinaryData());
        if (!lobWrites.isEmpty()) {
            lobData = event.isBinaryData() ? new BlobChunkList(lobWrites) : String.join((CharSequence)"", lobWrites);
        }
        if ((lobEraseEvents = this.readAndConsumeLobEraseEvents(transaction, index)) > 0) {
            LOGGER.warn("LOB_ERASE for table '{}' column '{}' is not supported, use DML operations to manipulate LOB columns only.", (Object)event.getTableId(), (Object)event.getColumnName());
            if (lobWrites.isEmpty()) {
                transaction.events.remove(index);
                return true;
            }
        } else if (lobEraseEvents == 0 && lobWrites.isEmpty()) {
            transaction.events.remove(index);
            return true;
        }
        if (prevEvent == null) {
            LOGGER.trace("\tAdding column '{}' to current event", (Object)event.getColumnName());
            event.getEntry().getNewValues()[columnIndex] = lobData;
            return false;
        }
        if (1 == prevEvent.getOperation()) {
            if (this.isForSameTableOrScn(event, prevEvent)) {
                LOGGER.trace("\tMerging SEL_LOB_LOCATOR with previous INSERT event");
                Object prevValue = prevEvent.getEntry().getNewValues()[columnIndex];
                if (!"EMPTY_CLOB()".equals(prevValue) && !"EMPTY_BLOB()".equals(prevValue)) {
                    throw new DebeziumException("Expected to find column '" + event.getColumnName() + "' in table '" + prevEvent.getTableId() + "' to be initialized as an empty LOB value.'");
                }
                prevEvent.getEntry().getNewValues()[columnIndex] = lobData;
                transaction.events.remove(index);
                return true;
            }
        } else if (3 == prevEvent.getOperation()) {
            if (this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tUpdating SEL_LOB_LOCATOR column '{}' to previous UPDATE event", (Object)event.getColumnName());
                prevEvent.getEntry().getNewValues()[columnIndex] = lobData;
                transaction.events.remove(index);
                return true;
            }
        } else if (9 == prevEvent.getOperation()) {
            if (this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tAdding column '{}' to previous SEL_LOB_LOCATOR event", (Object)event.getColumnName());
                prevEvent.getEntry().getNewValues()[columnIndex] = lobData;
                transaction.events.remove(index);
                return true;
            }
        } else {
            throw new DebeziumException("Unexpected previous event operation: " + prevEvent.getOperation());
        }
        LOGGER.trace("\tSEL_LOB_LOCATOR event is for different row, merge skipped.");
        LOGGER.trace("\tAdding column '{}' to current event", (Object)event.getColumnName());
        event.getEntry().getNewValues()[columnIndex] = lobData;
        return false;
    }

    private boolean shouldMergeDmlEvent(Transaction transaction, int index, DmlEvent event, LogMinerEvent prevEvent) {
        LOGGER.trace("\tDetected DmlEvent {}", (Object)event.getOperation());
        if (prevEvent == null) {
            return false;
        }
        if (1 == prevEvent.getOperation()) {
            if (3 == event.getOperation() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tMerging UPDATE event with previous INSERT event");
                this.mergeNewColumns(event, prevEvent);
                transaction.events.remove(index);
                return true;
            }
        } else if (3 == prevEvent.getOperation()) {
            if (3 == event.getOperation() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tMerging UPDATE event with previous UPDATE event");
                this.mergeNewColumns(event, prevEvent);
                transaction.events.remove(index);
                return true;
            }
        } else if (9 == prevEvent.getOperation() && 3 == event.getOperation() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
            LOGGER.trace("\tMerging UPDATE event with previous SEL_LOB_LOCATOR event");
            for (int i = 0; i < event.getEntry().getNewValues().length; ++i) {
                Object value = event.getEntry().getNewValues()[i];
                Object prevValue = prevEvent.getEntry().getNewValues()[i];
                if (prevValue != null || value == null) continue;
                LOGGER.trace("\tAdding column index {} to previous SEL_LOB_LOCATOR event", (Object)i);
                prevEvent.getEntry().getNewValues()[i] = value;
            }
            transaction.events.remove(index);
            return true;
        }
        LOGGER.trace("\tDmlEvent {} event is for different row, merge skipped.", (Object)event.getOperation());
        return false;
    }

    private List<String> readAndCombineLobWriteEvents(Transaction transaction, int index, boolean binaryData) {
        LogMinerEvent event;
        int i;
        ArrayList<String> chunks = new ArrayList<String>();
        for (i = index + 1; i < transaction.events.size() && (event = (LogMinerEvent)transaction.events.get(i)) instanceof LobWriteEvent; ++i) {
            LobWriteEvent writeEvent = (LobWriteEvent)event;
            if (binaryData && !writeEvent.getData().startsWith("HEXTORAW('") && !writeEvent.getData().endsWith("')")) {
                throw new DebeziumException("Unexpected BLOB data chunk: " + writeEvent.getData());
            }
            chunks.add(writeEvent.getData());
        }
        if (!chunks.isEmpty()) {
            LOGGER.trace("\tCombined {} LobWriteEvent events", (Object)chunks.size());
            for (i = 0; i < chunks.size(); ++i) {
                transaction.events.remove(index + 1);
            }
        }
        return chunks;
    }

    private int readAndConsumeLobEraseEvents(Transaction transaction, int index) {
        LogMinerEvent event;
        int i;
        int events = 0;
        for (i = index + 1; i < transaction.events.size() && (event = (LogMinerEvent)transaction.events.get(i)) instanceof LobEraseEvent; ++i) {
            ++events;
        }
        if (events > 0) {
            LOGGER.trace("\tConsumed {} LobErase events", (Object)events);
            for (i = 0; i < events; ++i) {
                transaction.events.remove(index + 1);
            }
        }
        return events;
    }

    private boolean isForSameTableOrScn(LogMinerEvent event, LogMinerEvent prevEvent) {
        if (prevEvent != null) {
            if (event.getTableId().equals((Object)prevEvent.getTableId())) {
                return true;
            }
            return event.getScn().equals(prevEvent.getScn()) && event.getRsId().equals(prevEvent.getRsId());
        }
        return false;
    }

    private boolean isSameTableRow(LogMinerEvent event, LogMinerEvent prevEvent) {
        Table table = this.schema.tableFor(event.getTableId());
        if (table == null) {
            LOGGER.trace("Unable to locate table '{}' schema, unable to detect if same row.", (Object)event.getTableId());
            return false;
        }
        for (String columnName : table.primaryKeyColumnNames()) {
            int position = LogMinerHelper.getColumnIndexByName(columnName, table);
            Object prevValue = prevEvent.getEntry().getNewValues()[position];
            if (prevValue == null) {
                throw new DebeziumException("Could not find column " + columnName + " in previous event");
            }
            Object value = event.getEntry().getNewValues()[position];
            if (value == null) {
                throw new DebeziumException("Could not find column " + columnName + " in event");
            }
            if (Objects.equals(value, prevValue)) continue;
            return false;
        }
        return true;
    }

    private void mergeNewColumns(LogMinerEvent event, LogMinerEvent prevEvent) {
        boolean prevEventIsInsert = 1 == prevEvent.getOperation();
        for (int i = 0; i < event.getEntry().getNewValues().length; ++i) {
            Object value = event.getEntry().getNewValues()[i];
            Object prevValue = prevEvent.getEntry().getNewValues()[i];
            if (prevEventIsInsert && "EMPTY_CLOB()".equals(prevValue)) {
                LOGGER.trace("\tAssigning column index {} with updated CLOB value.", (Object)i);
                prevEvent.getEntry().getNewValues()[i] = value;
                continue;
            }
            if (prevEventIsInsert && "EMPTY_BLOB()".equals(prevValue)) {
                LOGGER.trace("\tAssigning column index {} with updated BLOB value.", (Object)i);
                prevEvent.getEntry().getNewValues()[i] = value;
                continue;
            }
            if (prevEventIsInsert || value == null) continue;
            LOGGER.trace("\tUpdating column index {} in previous event", (Object)i);
            prevEvent.getEntry().getNewValues()[i] = value;
        }
    }

    private static class LobEraseEvent
    extends LogMinerEvent {
        public LobEraseEvent(int operation, Scn scn, TableId tableId, String rowId, Object rsId) {
            super(operation, null, scn, tableId, rowId, rsId);
        }
    }

    private static class LobWriteEvent
    extends LogMinerEvent {
        private final String data;

        public LobWriteEvent(int operation, String data, Scn scn, TableId tableId, String rowId, Object rsId) {
            super(operation, null, scn, tableId, rowId, rsId);
            this.data = data;
        }

        public String getData() {
            return this.data;
        }
    }

    private static class SelectLobLocatorEvent
    extends LogMinerEvent {
        private final String columnName;
        private final boolean binaryData;

        public SelectLobLocatorEvent(int operation, LogMinerDmlEntry entry, String columnName, boolean binaryData, Scn scn, TableId tableId, String rowId, Object rsId) {
            super(operation, entry, scn, tableId, rowId, rsId);
            this.columnName = columnName;
            this.binaryData = binaryData;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isBinaryData() {
            return this.binaryData;
        }
    }

    private static class DmlEvent
    extends LogMinerEvent {
        public DmlEvent(int operation, LogMinerDmlEntry entry, Scn scn, TableId tableId, String rowId, Object rsId) {
            super(operation, entry, scn, tableId, rowId, rsId);
        }
    }

    private static class LogMinerEvent {
        private final int operation;
        private final LogMinerDmlEntry entry;
        private final Scn scn;
        private final TableId tableId;
        private final String rowId;
        private final Object rsId;

        public LogMinerEvent(int operation, LogMinerDmlEntry entry, Scn scn, TableId tableId, String rowId, Object rsId) {
            this.operation = operation;
            this.scn = scn;
            this.tableId = tableId;
            this.rowId = rowId;
            this.rsId = rsId;
            this.entry = entry;
        }

        public int getOperation() {
            return this.operation;
        }

        public LogMinerDmlEntry getEntry() {
            return this.entry;
        }

        public Scn getScn() {
            return this.scn;
        }

        public TableId getTableId() {
            return this.tableId;
        }

        public String getRowId() {
            return this.rowId;
        }

        public Object getRsId() {
            return this.rsId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogMinerEvent event = (LogMinerEvent)o;
            return this.operation == event.operation && Objects.equals(this.entry, event.entry) && Objects.equals(this.scn, event.scn) && Objects.equals(this.tableId, event.tableId) && Objects.equals(this.rowId, event.rowId) && Objects.equals(this.rsId, event.rsId);
        }

        public int hashCode() {
            return Objects.hash(this.operation, this.entry, this.scn, this.tableId, this.rowId, this.rsId);
        }
    }

    private static final class Transaction {
        private final String transactionId;
        private final Scn firstScn;
        private Scn lastScn;
        private final List<LogMinerEvent> events;
        private int eventIds;

        private Transaction(String transactionId, Scn firstScn) {
            this.transactionId = transactionId;
            this.firstScn = firstScn;
            this.events = new ArrayList<LogMinerEvent>();
            this.lastScn = firstScn;
            this.eventIds = 0;
        }

        public String toString() {
            return "Transaction{transactionId=" + this.transactionId + ", firstScn=" + this.firstScn + ", lastScn=" + this.lastScn + ", eventIds=" + this.eventIds + '}';
        }
    }

    private static final class RecentlyCommittedTransaction {
        private final String transactionId;
        private final Scn firstScn;
        private final Scn commitScn;

        public RecentlyCommittedTransaction(Transaction transaction, Scn commitScn) {
            this.transactionId = transaction.transactionId;
            this.firstScn = transaction.firstScn;
            this.commitScn = commitScn;
        }

        public Scn getFirstScn() {
            return this.firstScn;
        }

        public Scn getCommitScn() {
            return this.commitScn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecentlyCommittedTransaction that = (RecentlyCommittedTransaction)o;
            return Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.firstScn, that.firstScn) && Objects.equals(this.commitScn, that.commitScn);
        }

        public int hashCode() {
            return Objects.hash(this.transactionId, this.firstScn, this.commitScn);
        }
    }
}

