/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.List;

public class CommandGroupMetadata {
    private final String name;
    private final String description;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> commands;

    public CommandGroupMetadata(String name, String description, Iterable<OptionMetadata> options, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        this.name = name;
        this.description = description;
        this.options = ImmutableList.copyOf(options);
        this.defaultCommand = defaultCommand;
        this.commands = ImmutableList.copyOf(commands);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getCommands() {
        return this.commands;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandGroupMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", commands=").append(this.commands);
        sb.append('}');
        return sb.toString();
    }

    public static Function<CommandGroupMetadata, String> nameGetter() {
        return new Function<CommandGroupMetadata, String>(){

            public String apply(CommandGroupMetadata input) {
                return input.getName();
            }
        };
    }
}

