/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.BrowserEntry;
import cz.mallat.uasparser.DeviceEntry;
import cz.mallat.uasparser.OsEntry;
import cz.mallat.uasparser.RobotEntry;

public class UserAgentInfo {
    public static final String UNKNOWN = "unknown";
    private String type = "unknown";
    private String browserVersionInfo;
    private RobotEntry robotEntry;
    private BrowserEntry browserEntry;
    private OsEntry osEntry;
    private DeviceEntry deviceEntry;

    public boolean isRobot() {
        return "Robot".equals(this.type);
    }

    public boolean hasOsInfo() {
        return this.osEntry != null;
    }

    public boolean hasDeviceInfo() {
        return this.deviceEntry != null;
    }

    public String getType() {
        if (this.type == null) {
            return UNKNOWN;
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUaFamily() {
        if (this.browserEntry != null) {
            return this.browserEntry.getFamily();
        }
        if (this.robotEntry != null) {
            return this.robotEntry.getFamily();
        }
        return UNKNOWN;
    }

    public String getUaName() {
        if (this.browserEntry != null) {
            if (this.browserVersionInfo != null && !this.browserVersionInfo.isEmpty()) {
                return this.getUaFamily() + " " + this.browserVersionInfo;
            }
            return this.getUaFamily();
        }
        if (this.robotEntry != null) {
            return this.robotEntry.getName();
        }
        return UNKNOWN;
    }

    public String getUaUrl() {
        if (this.browserEntry != null) {
            return this.browserEntry.getUrl();
        }
        if (this.robotEntry != null) {
            return this.robotEntry.getUrl();
        }
        return UNKNOWN;
    }

    public String getUaInfoUrl() {
        if (this.browserEntry != null) {
            return "http://user-agent-string.info" + this.browserEntry.getInfoUrl();
        }
        if (this.robotEntry != null) {
            return "http://user-agent-string.info" + this.robotEntry.getInfoUrl();
        }
        return UNKNOWN;
    }

    public String getUaCompany() {
        if (this.browserEntry != null) {
            return this.browserEntry.getCompany();
        }
        if (this.robotEntry != null) {
            return this.robotEntry.getCompany();
        }
        return UNKNOWN;
    }

    public String getUaCompanyUrl() {
        if (this.browserEntry != null) {
            return this.browserEntry.getCompanyUrl();
        }
        if (this.robotEntry != null) {
            return this.robotEntry.getCompanyUrl();
        }
        return UNKNOWN;
    }

    public String getUaIcon() {
        if (this.browserEntry != null) {
            return this.browserEntry.getIco();
        }
        if (this.robotEntry != null) {
            return this.robotEntry.getIco();
        }
        return UNKNOWN;
    }

    public String getOsFamily() {
        if (this.osEntry != null) {
            return this.osEntry.getFamily();
        }
        return UNKNOWN;
    }

    public String getOsName() {
        if (this.osEntry != null) {
            return this.osEntry.getName();
        }
        return UNKNOWN;
    }

    public String getOsUrl() {
        if (this.osEntry != null) {
            return this.osEntry.getUrl();
        }
        return UNKNOWN;
    }

    public String getOsCompany() {
        if (this.osEntry != null) {
            return this.osEntry.getCompany();
        }
        return UNKNOWN;
    }

    public String getOsCompanyUrl() {
        if (this.osEntry != null) {
            return this.osEntry.getCompanyUrl();
        }
        return UNKNOWN;
    }

    public String getOsIcon() {
        if (this.osEntry != null) {
            return this.osEntry.getIco();
        }
        return UNKNOWN;
    }

    public String getBrowserVersionInfo() {
        return this.browserVersionInfo;
    }

    public String getDeviceType() {
        return this.deviceEntry != null ? this.deviceEntry.getType() : UNKNOWN;
    }

    public String getDeviceIcon() {
        return this.deviceEntry != null ? this.deviceEntry.getIco() : UNKNOWN;
    }

    public String getDeviceInfoUrl() {
        return this.deviceEntry != null ? "http://user-agent-string.info" + this.deviceEntry.getInfoUrl() : UNKNOWN;
    }

    public void setBrowserEntry(BrowserEntry browserEntry) {
        this.browserEntry = browserEntry;
    }

    public void setBrowserVersionInfo(String browserVersionInfo) {
        this.browserVersionInfo = browserVersionInfo;
    }

    public void setOsEntry(OsEntry osEntry) {
        this.osEntry = osEntry;
    }

    public void setRobotEntry(RobotEntry robotEntry) {
        this.robotEntry = robotEntry;
    }

    public void setDeviceEntry(DeviceEntry deviceEntry) {
        this.deviceEntry = deviceEntry;
    }
}

