/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.BrowserEntry;
import cz.mallat.uasparser.DeviceEntry;
import cz.mallat.uasparser.OsEntry;
import cz.mallat.uasparser.RobotEntry;
import cz.mallat.uasparser.UserAgentInfo;
import cz.mallat.uasparser.fileparser.Entry;
import cz.mallat.uasparser.fileparser.PHPFileParser;
import cz.mallat.uasparser.fileparser.Section;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jregex.Matcher;
import jregex.Pattern;

public class UASparser {
    static final String INFO_URL = "http://user-agent-string.info";
    static final String ROBOT = "Robot";
    protected Map<String, RobotEntry> robotsMap;
    protected Map<Long, OsEntry> osMap;
    protected Map<Long, BrowserEntry> browserMap;
    protected Map<Long, String> browserTypeMap;
    protected Map<String, Long> browserRegMap;
    protected Map<Long, Long> browserOsMap;
    protected Map<String, Long> osRegMap;
    protected Map<Long, DeviceEntry> deviceMap;
    protected Map<String, Long> deviceRegMap;
    protected Map<Pattern, Long> compiledBrowserRegMap;
    protected Map<Pattern, Long> compiledOsRegMap;
    protected Map<Pattern, Long> compiledDeviceRegMap;
    protected UserAgentInfo unknownAgentInfo;

    public UASparser() {
    }

    public UASparser(String localDefinitionFilename) throws IOException {
        this.loadDataFromFile(new File(localDefinitionFilename));
        this.unknownAgentInfo = new UserAgentInfo();
    }

    public UASparser(InputStream inputStreamToDefinitionFile) throws IOException {
        this.loadDataFromFile(inputStreamToDefinitionFile);
        this.unknownAgentInfo = new UserAgentInfo();
    }

    @Deprecated
    protected void checkDataMaps() throws IOException {
    }

    public UserAgentInfo parse(String useragent) throws IOException {
        if (useragent == null) {
            return this.unknownAgentInfo;
        }
        UserAgentInfo uaInfo = new UserAgentInfo();
        useragent = useragent.trim();
        this.checkDataMaps();
        this.processRobot(useragent, uaInfo);
        if (!uaInfo.isRobot()) {
            this.processBrowserRegex(useragent, uaInfo);
            if (!uaInfo.hasOsInfo()) {
                this.processOsRegex(useragent, uaInfo);
            }
            this.processDeviceRegex(useragent, uaInfo);
        }
        return uaInfo;
    }

    public UserAgentInfo parseBrowserOnly(String useragent) {
        if (useragent == null) {
            return this.unknownAgentInfo;
        }
        UserAgentInfo uaInfo = new UserAgentInfo();
        this.processBrowserRegex(useragent, uaInfo);
        return uaInfo;
    }

    protected void preCompileRegExes() {
        this.preCompileBrowserRegMap();
        this.preCompileOsRegMap();
        this.preCompileDeviceRegMap();
    }

    protected void preCompileBrowserRegMap() {
        LinkedHashMap<Pattern, Long> compiledBrowserRegMap = new LinkedHashMap<Pattern, Long>(this.browserRegMap.size());
        for (Map.Entry<String, Long> entry : this.browserRegMap.entrySet()) {
            Pattern pattern = new Pattern(entry.getKey(), 5);
            compiledBrowserRegMap.put(pattern, entry.getValue());
        }
        this.compiledBrowserRegMap = compiledBrowserRegMap;
    }

    protected void preCompileOsRegMap() {
        LinkedHashMap<Pattern, Long> compiledOsRegMap = new LinkedHashMap<Pattern, Long>(this.osRegMap.size());
        for (Map.Entry<String, Long> entry : this.osRegMap.entrySet()) {
            Pattern pattern = new Pattern(entry.getKey(), 5);
            compiledOsRegMap.put(pattern, entry.getValue());
        }
        this.compiledOsRegMap = compiledOsRegMap;
    }

    protected void preCompileDeviceRegMap() {
        if (this.deviceRegMap != null) {
            LinkedHashMap<Pattern, Long> compiledDeviceRegMap = new LinkedHashMap<Pattern, Long>(this.deviceRegMap.size());
            for (Map.Entry<String, Long> entry : this.deviceRegMap.entrySet()) {
                Pattern pattern = new Pattern(entry.getKey(), 5);
                compiledDeviceRegMap.put(pattern, entry.getValue());
            }
            this.compiledDeviceRegMap = compiledDeviceRegMap;
        }
    }

    protected void processRobot(String useragent, UserAgentInfo uaInfo) {
        if (this.robotsMap.containsKey(useragent)) {
            uaInfo.setType(ROBOT);
            RobotEntry robotEntry = this.robotsMap.get(useragent);
            uaInfo.setRobotEntry(robotEntry);
            if (robotEntry.getOsId() != null) {
                uaInfo.setOsEntry(this.osMap.get(robotEntry.getOsId()));
            }
        }
    }

    protected void processBrowserRegex(String useragent, UserAgentInfo uaInfo) {
        for (Map.Entry<Pattern, Long> entry : this.compiledBrowserRegMap.entrySet()) {
            Long idOs;
            Matcher matcher = entry.getKey().matcher(useragent);
            if (!matcher.find()) continue;
            Long idBrowser = entry.getValue();
            BrowserEntry be = this.browserMap.get(idBrowser);
            if (be != null) {
                uaInfo.setType(this.browserTypeMap.get(be.getType()));
                if (matcher.groupCount() > 1) {
                    uaInfo.setBrowserVersionInfo(matcher.group(1));
                }
                uaInfo.setBrowserEntry(be);
            }
            if ((idOs = this.browserOsMap.get(idBrowser)) != null) {
                uaInfo.setOsEntry(this.osMap.get(idOs));
            }
            return;
        }
    }

    protected void processOsRegex(String useragent, UserAgentInfo uaInfo) {
        for (Map.Entry<Pattern, Long> entry : this.compiledOsRegMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(useragent);
            if (!matcher.find()) continue;
            uaInfo.setOsEntry(this.osMap.get(entry.getValue()));
            return;
        }
    }

    protected void processDeviceRegex(String useragent, UserAgentInfo uaInfo) {
        if (this.compiledDeviceRegMap != null && this.deviceMap != null) {
            for (Map.Entry<Pattern, Long> entry : this.compiledDeviceRegMap.entrySet()) {
                Matcher matcher = entry.getKey().matcher(useragent);
                if (!matcher.find()) continue;
                uaInfo.setDeviceEntry(this.deviceMap.get(entry.getValue()));
                return;
            }
        }
    }

    protected void loadDataFromFile(File definitionFile) throws IOException {
        PHPFileParser fp = new PHPFileParser(definitionFile);
        this.createInternalDataStructure(fp.getSections());
    }

    protected void loadDataFromFile(InputStream is) throws IOException {
        PHPFileParser fp = new PHPFileParser(is);
        this.createInternalDataStructure(fp.getSections());
    }

    protected void createInternalDataStructure(List<Section> sectionList) {
        for (Section sec : sectionList) {
            Iterator<String> it;
            if ("robots".equals(sec.getName())) {
                HashMap<String, RobotEntry> robotsMapTmp = new HashMap<String, RobotEntry>();
                for (Entry en : sec.getEntries()) {
                    RobotEntry re = new RobotEntry(en.getData());
                    robotsMapTmp.put(re.getUserAgentString(), re);
                }
                this.robotsMap = robotsMapTmp;
                continue;
            }
            if ("os".equals(sec.getName())) {
                HashMap<Long, OsEntry> osMapTmp = new HashMap<Long, OsEntry>();
                for (Entry en : sec.getEntries()) {
                    OsEntry oe = new OsEntry(en.getData());
                    osMapTmp.put(Long.parseLong(en.getKey()), oe);
                }
                this.osMap = osMapTmp;
                continue;
            }
            if ("browser".equals(sec.getName())) {
                HashMap<Long, BrowserEntry> browserMapTmp = new HashMap<Long, BrowserEntry>();
                for (Entry en : sec.getEntries()) {
                    BrowserEntry be = new BrowserEntry(en.getData());
                    browserMapTmp.put(Long.parseLong(en.getKey()), be);
                }
                this.browserMap = browserMapTmp;
                continue;
            }
            if ("browser_type".equals(sec.getName())) {
                HashMap<Long, String> browserTypeMapTmp = new HashMap<Long, String>();
                for (Entry en : sec.getEntries()) {
                    browserTypeMapTmp.put(Long.parseLong(en.getKey()), en.getData().iterator().next());
                }
                this.browserTypeMap = browserTypeMapTmp;
                continue;
            }
            if ("browser_reg".equals(sec.getName())) {
                LinkedHashMap<String, Long> browserRegMapTmp = new LinkedHashMap<String, Long>();
                for (Entry en : sec.getEntries()) {
                    it = en.getData().iterator();
                    browserRegMapTmp.put(this.convertPerlToJavaRegex(it.next()), Long.parseLong(it.next()));
                }
                this.browserRegMap = browserRegMapTmp;
                continue;
            }
            if ("browser_os".equals(sec.getName())) {
                HashMap<Long, Long> browserOsMapTmp = new HashMap<Long, Long>();
                for (Entry en : sec.getEntries()) {
                    browserOsMapTmp.put(Long.parseLong(en.getKey()), Long.parseLong(en.getData().iterator().next()));
                }
                this.browserOsMap = browserOsMapTmp;
                continue;
            }
            if ("os_reg".equals(sec.getName())) {
                LinkedHashMap<String, Long> osRegMapTmp = new LinkedHashMap<String, Long>();
                for (Entry en : sec.getEntries()) {
                    it = en.getData().iterator();
                    osRegMapTmp.put(this.convertPerlToJavaRegex(it.next()), Long.parseLong(it.next()));
                }
                this.osRegMap = osRegMapTmp;
                continue;
            }
            if ("device".equals(sec.getName())) {
                HashMap<Long, DeviceEntry> deviceMapTmp = new HashMap<Long, DeviceEntry>();
                for (Entry en : sec.getEntries()) {
                    DeviceEntry de = new DeviceEntry(en.getData());
                    deviceMapTmp.put(Long.parseLong(en.getKey()), de);
                }
                this.deviceMap = deviceMapTmp;
                continue;
            }
            if (!"device_reg".equals(sec.getName())) continue;
            LinkedHashMap<String, Long> deviceRegMapTmp = new LinkedHashMap<String, Long>();
            for (Entry en : sec.getEntries()) {
                it = en.getData().iterator();
                deviceRegMapTmp.put(this.convertPerlToJavaRegex(it.next()), Long.parseLong(it.next()));
            }
            this.deviceRegMap = deviceRegMapTmp;
        }
        this.preCompileRegExes();
    }

    protected String convertPerlToJavaRegex(String regex) {
        regex = regex.substring(1);
        int lastIndex = regex.lastIndexOf(47);
        regex = regex.substring(0, lastIndex);
        return regex;
    }
}

