/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.BrowserEntry;
import cz.mallat.uasparser.DeviceEntry;
import cz.mallat.uasparser.OsEntry;
import cz.mallat.uasparser.UASparser;
import cz.mallat.uasparser.UserAgentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jregex.Matcher;
import jregex.Pattern;

public class SingleThreadedUASparser
extends UASparser {
    protected Map<Matcher, Long> compiledBrowserMatcherMap;
    protected Map<Matcher, Long> compiledOsMatcherMap;
    protected Map<Matcher, Long> compiledDeviceMatcherMap;

    public SingleThreadedUASparser(InputStream inputStreamToDefinitionFile) throws IOException {
        super(inputStreamToDefinitionFile);
    }

    public SingleThreadedUASparser(String localDefinitionFilename) throws IOException {
        super(localDefinitionFilename);
    }

    @Override
    protected void preCompileBrowserRegMap() {
        this.compiledBrowserMatcherMap = this.preCompileBrowserMatcherMap();
    }

    protected LinkedHashMap<Matcher, Long> preCompileBrowserMatcherMap() {
        LinkedHashMap<Matcher, Long> compiledBrowserMatcherMap = new LinkedHashMap<Matcher, Long>(this.browserRegMap.size());
        for (Map.Entry entry : this.browserRegMap.entrySet()) {
            Pattern pattern = new Pattern((String)entry.getKey(), 5);
            compiledBrowserMatcherMap.put(pattern.matcher(), (Long)entry.getValue());
        }
        return compiledBrowserMatcherMap;
    }

    @Override
    protected void preCompileOsRegMap() {
        this.compiledOsMatcherMap = this.preCompileOsMatcherMap();
    }

    protected LinkedHashMap<Matcher, Long> preCompileOsMatcherMap() {
        LinkedHashMap<Matcher, Long> compiledOsMatcherMap = new LinkedHashMap<Matcher, Long>(this.osRegMap.size());
        for (Map.Entry entry : this.osRegMap.entrySet()) {
            Pattern pattern = new Pattern((String)entry.getKey(), 5);
            compiledOsMatcherMap.put(pattern.matcher(), (Long)entry.getValue());
        }
        return compiledOsMatcherMap;
    }

    @Override
    protected void preCompileDeviceRegMap() {
        this.compiledDeviceMatcherMap = this.preCompileDeviceMatcherMap();
    }

    protected LinkedHashMap<Matcher, Long> preCompileDeviceMatcherMap() {
        if (this.deviceRegMap == null) {
            return null;
        }
        LinkedHashMap<Matcher, Long> compiledDeviceMatcherMap = new LinkedHashMap<Matcher, Long>(this.deviceRegMap.size());
        for (Map.Entry entry : this.deviceRegMap.entrySet()) {
            Pattern pattern = new Pattern((String)entry.getKey(), 5);
            compiledDeviceMatcherMap.put(pattern.matcher(), (Long)entry.getValue());
        }
        return compiledDeviceMatcherMap;
    }

    @Override
    protected void processOsRegex(String useragent, UserAgentInfo retObj) {
        Set<Map.Entry<Matcher, Long>> osMatcherSet = this.getOsMatcherSet();
        for (Map.Entry<Matcher, Long> entry : osMatcherSet) {
            Matcher matcher = entry.getKey();
            matcher.setTarget(useragent);
            if (!matcher.find()) continue;
            retObj.setOsEntry((OsEntry)this.osMap.get(entry.getValue()));
            break;
        }
    }

    @Override
    protected void processBrowserRegex(String useragent, UserAgentInfo retObj) {
        Set<Map.Entry<Matcher, Long>> browserMatcherSet = this.getBrowserMatcherSet();
        for (Map.Entry<Matcher, Long> entry : browserMatcherSet) {
            Long idOs;
            Matcher matcher = entry.getKey();
            matcher.setTarget(useragent);
            if (!matcher.find()) continue;
            Long idBrowser = entry.getValue();
            BrowserEntry be = (BrowserEntry)this.browserMap.get(idBrowser);
            if (be != null) {
                retObj.setType((String)this.browserTypeMap.get(be.getType()));
                if (matcher.groupCount() > 1) {
                    retObj.setBrowserVersionInfo(matcher.group(1));
                }
                retObj.setBrowserEntry(be);
            }
            if ((idOs = (Long)this.browserOsMap.get(idBrowser)) != null) {
                retObj.setOsEntry((OsEntry)this.osMap.get(idOs));
            }
            return;
        }
    }

    @Override
    protected void processDeviceRegex(String useragent, UserAgentInfo uaInfo) {
        Set<Map.Entry<Matcher, Long>> deviceMatcherSet = this.getDeviceMatcherSet();
        if (deviceMatcherSet == null || this.deviceMap == null) {
            return;
        }
        for (Map.Entry<Matcher, Long> entry : deviceMatcherSet) {
            Matcher matcher = entry.getKey();
            matcher.setTarget(useragent);
            if (!matcher.find()) continue;
            uaInfo.setDeviceEntry((DeviceEntry)this.deviceMap.get(entry.getValue()));
            return;
        }
    }

    protected Set<Map.Entry<Matcher, Long>> getOsMatcherSet() {
        return this.compiledOsMatcherMap.entrySet();
    }

    protected Set<Map.Entry<Matcher, Long>> getBrowserMatcherSet() {
        return this.compiledBrowserMatcherMap.entrySet();
    }

    protected Set<Map.Entry<Matcher, Long>> getDeviceMatcherSet() {
        if (this.compiledDeviceMatcherMap == null) {
            return null;
        }
        return this.compiledDeviceMatcherMap.entrySet();
    }
}

