/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.UASparser;
import cz.mallat.uasparser.fileparser.PHPFileParser;
import cz.mallat.uasparser.fileparser.Section;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class OnlineUpdater
extends Thread {
    public static final String CACHE_FILENAME = "user_agent_strings.txt";
    public static final String PROPERTIES_FILENAME = "user_agent_strings-version.txt";
    protected static final String DATA_RETRIVE_URL = "http://user-agent-string.info/rpc/get_data.php?key=free&format=ini";
    protected static final String VERSION_CHECK_URL = "http://user-agent-string.info/rpc/get_data.php?key=free&format=ini&ver=y";
    protected final long updateInterval;
    protected int currentVersion;
    protected UASparser parser;
    protected File cacheFile;
    protected File propsFile;

    public OnlineUpdater(UASparser parser) {
        this(parser, null, 1L, TimeUnit.DAYS);
    }

    public OnlineUpdater(UASparser parser, String cacheDir, long interval, TimeUnit units) {
        this.parser = parser;
        if (cacheDir == null) {
            cacheDir = System.getProperty("java.io.tmpdir");
        }
        if (!new File(cacheDir).canWrite()) {
            throw new RuntimeException("Can't write to cacheDir: " + cacheDir);
        }
        this.cacheFile = new File(cacheDir, CACHE_FILENAME);
        this.propsFile = new File(cacheDir, PROPERTIES_FILENAME);
        this.currentVersion = 0;
        this.updateInterval = units.toMillis(interval);
        this.init();
        this.start();
    }

    public void init() {
        if (this.cacheFile.exists()) {
            try {
                this.parser.loadDataFromFile(this.cacheFile);
                this.currentVersion = Integer.parseInt(new BufferedReader(new FileReader(this.propsFile)).readLine());
                return;
            }
            catch (Throwable t) {
                this.currentVersion = 0;
            }
        }
        try {
            this.parser.loadDataFromFile(OnlineUpdater.getVendoredInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream getVendoredInputStream() {
        return OnlineUpdater.class.getClassLoader().getResourceAsStream(CACHE_FILENAME);
    }

    public boolean update() {
        try {
            int versionOnServer = this.getVersionFromServer();
            if (this.currentVersion == 0 || versionOnServer > this.currentVersion) {
                this.parser.createInternalDataStructure(this.loadDataFromInternet());
                this.currentVersion = versionOnServer;
                FileWriter writer = new FileWriter(this.propsFile);
                writer.write(Integer.toString(this.currentVersion));
                writer.close();
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void run() {
        while (true) {
            this.update();
            try {
                Thread.sleep(this.updateInterval + (long)(new Random().nextInt(300) * 1000));
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Section> loadDataFromInternet() throws IOException {
        File tmpFile = File.createTempFile("uas", ".txt");
        try {
            BufferedReader reader = null;
            OutputStreamWriter writer = null;
            try {
                URL url = new URL(DATA_RETRIVE_URL);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                writer = new FileWriter(tmpFile);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.write(System.getProperty("line.separator"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            try {
                PHPFileParser fp = new PHPFileParser(tmpFile);
                List<Section> sections = fp.getSections();
                if (this.cacheFile.exists()) {
                    this.cacheFile.delete();
                }
                if (!tmpFile.renameTo(this.cacheFile)) {
                    this.copyFile(tmpFile, this.cacheFile);
                }
                List<Section> list = sections;
                return list;
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
        }
        finally {
            if (tmpFile.compareTo(this.cacheFile) != 0) {
                tmpFile.delete();
            }
        }
    }

    protected void copyFile(File src, File dest) throws FileNotFoundException, IOException {
        int length;
        FileInputStream inStream = new FileInputStream(src);
        FileOutputStream outStream = new FileOutputStream(dest);
        byte[] buffer = new byte[4096];
        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
            ((OutputStream)outStream).write(buffer, 0, length);
        }
        ((InputStream)inStream).close();
        ((OutputStream)outStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getVersionFromServer() throws IOException {
        URL url = new URL(VERSION_CHECK_URL);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String ver = reader.readLine();
            if (ver == null || ver.isEmpty()) {
                throw new IOException("Failed to read version number");
            }
            int n = Integer.parseInt(ver.replace("-", ""));
            return n;
        }
    }
}

