/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.SingleThreadedUASparser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import jregex.Matcher;

public class MultithreadedUASparser
extends SingleThreadedUASparser {
    private ThreadLocal<Map<Matcher, Long>> compiledBrowserMatcherMapT;
    private ThreadLocal<Map<Matcher, Long>> compiledOsMatcherMapT;
    private ThreadLocal<Map<Matcher, Long>> compiledDeviceMatcherMapT;

    public MultithreadedUASparser(InputStream inputStreamToDefinitionFile) throws IOException {
        super(inputStreamToDefinitionFile);
    }

    public MultithreadedUASparser(String localDefinitionFilename) throws IOException {
        super(localDefinitionFilename);
    }

    @Override
    protected void preCompileBrowserRegMap() {
        this.compiledBrowserMatcherMapT = new ThreadLocal<Map<Matcher, Long>>(){

            @Override
            protected Map<Matcher, Long> initialValue() {
                return MultithreadedUASparser.this.preCompileBrowserMatcherMap();
            }
        };
    }

    @Override
    protected void preCompileOsRegMap() {
        this.compiledOsMatcherMapT = new ThreadLocal<Map<Matcher, Long>>(){

            @Override
            protected Map<Matcher, Long> initialValue() {
                return MultithreadedUASparser.this.preCompileOsMatcherMap();
            }
        };
    }

    @Override
    protected void preCompileDeviceRegMap() {
        this.compiledDeviceMatcherMapT = new ThreadLocal<Map<Matcher, Long>>(){

            @Override
            protected Map<Matcher, Long> initialValue() {
                return MultithreadedUASparser.this.preCompileDeviceMatcherMap();
            }
        };
    }

    @Override
    protected Set<Map.Entry<Matcher, Long>> getOsMatcherSet() {
        return this.compiledOsMatcherMapT.get().entrySet();
    }

    @Override
    protected Set<Map.Entry<Matcher, Long>> getBrowserMatcherSet() {
        return this.compiledBrowserMatcherMapT.get().entrySet();
    }

    @Override
    protected Set<Map.Entry<Matcher, Long>> getDeviceMatcherSet() {
        Map<Matcher, Long> map = this.compiledDeviceMatcherMapT.get();
        if (map == null) {
            return null;
        }
        return map.entrySet();
    }
}

