/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.OnlineUpdateUASparser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

@Deprecated
public class CachingOnlineUpdateUASparser
extends OnlineUpdateUASparser {
    private static final String CACHE_FILENAME = "userAgentString.txt";
    private static final String PROPERTIES_FILENAME = "userAgentString.properties";
    private final Properties prop;
    private final String cacheDir;

    public CachingOnlineUpdateUASparser() throws IOException {
        this((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachingOnlineUpdateUASparser(String cacheDir) throws IOException {
        this.cacheDir = cacheDir;
        this.prop = new Properties();
        if (cacheDir != null && !new File(cacheDir).canWrite()) {
            throw new RuntimeException("Can't write to cacheDir: " + cacheDir);
        }
        File propFile = this.getPropertiesFile();
        if (propFile.exists()) {
            try (FileInputStream fis = new FileInputStream(this.getPropertiesFile());){
                this.prop.load(fis);
                this.lastUpdateCheck = Long.parseLong(this.prop.getProperty("lastUpdateCheck"));
                this.currentVersion = this.prop.getProperty("currentVersion");
            }
            try {
                this.loadDataFromFile(this.getCacheFile());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.lastUpdateCheck = 0L;
                this.currentVersion = "";
            }
        }
    }

    @Override
    protected synchronized void checkDataMaps() throws IOException {
        if (this.lastUpdateCheck == 0L || this.lastUpdateCheck < System.currentTimeMillis() - 86400000L) {
            String versionOnServer = this.getVersionFromServer();
            if (this.currentVersion == null || versionOnServer.compareTo(this.currentVersion) > 0) {
                this.loadDataFromInternetAndSave();
                this.loadDataFromFile(this.getCacheFile());
                this.currentVersion = versionOnServer;
                this.prop.setProperty("currentVersion", this.currentVersion);
            }
            this.lastUpdateCheck = System.currentTimeMillis();
            this.prop.setProperty("lastUpdateCheck", Long.toString(this.lastUpdateCheck));
            this.saveProperties(this.prop);
        }
    }

    private File getCacheFile() {
        return new File(this.cacheDir == null ? System.getProperty("java.io.tmpdir") : this.cacheDir, CACHE_FILENAME);
    }

    private File getPropertiesFile() {
        return new File(this.cacheDir == null ? System.getProperty("java.io.tmpdir") : this.cacheDir, PROPERTIES_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataFromInternetAndSave() throws IOException {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            URL url = new URL("http://user-agent-string.info/rpc/get_data.php?key=free&format=ini");
            is = url.openStream();
            fos = new FileOutputStream(this.getCacheFile());
            byte[] buff = new byte[8192];
            int len = 0;
            while ((len = is.read(buff)) != -1) {
                fos.write(buff, 0, len);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties(Properties prop) throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.getPropertiesFile());){
            prop.store(fos, null);
        }
    }
}

