/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.BrowserEntry;
import cz.mallat.uasparser.UASparser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jregex.Matcher;
import jregex.Pattern;

public class BrowserFamilyParser
extends UASparser {
    protected Map<Pattern, Long> compiledBrowserRegMap;
    protected Map<Pattern, Long> compiledOsRegMap;
    public static final String UNKNOWN = "unknown";
    protected Map<String, Integer> browsers;

    public BrowserFamilyParser(InputStream inputStreamToDefinitionFile) throws IOException {
        super(inputStreamToDefinitionFile);
    }

    public BrowserFamilyParser(InputStream inputStreamToDefinitionFile, String[] browsers) throws IOException {
        super(inputStreamToDefinitionFile);
        this.setBrowsers(browsers);
    }

    public BrowserFamilyParser(String localDefinitionFilename) throws IOException {
        super(localDefinitionFilename);
    }

    public BrowserFamilyParser(String localDefinitionFilename, String[] browsers) throws IOException {
        super(localDefinitionFilename);
        this.setBrowsers(browsers);
    }

    private void setBrowsers(String[] browsers) {
        this.browsers = new HashMap<String, Integer>();
        for (String b : browsers) {
            this.browsers.put(b, 1);
        }
        this.preCompileRegExes();
    }

    public String parseBrowserFamily(String userAgent) {
        for (Map.Entry<Pattern, Long> entry : this.compiledBrowserRegMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(userAgent);
            if (!matcher.find()) continue;
            Long idBrowser = entry.getValue();
            BrowserEntry be = (BrowserEntry)this.browserMap.get(idBrowser);
            if (be != null) {
                return be.getFamily();
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    @Override
    protected void preCompileRegExes() {
        this.preCompileBrowserRegMap();
        this.preCompileOsRegMap();
    }

    @Override
    protected void preCompileBrowserRegMap() {
        this.compiledBrowserRegMap = new LinkedHashMap<Pattern, Long>(this.browserRegMap.size());
        for (Map.Entry entry : this.browserRegMap.entrySet()) {
            if (this.browsers != null && !this.browsers.containsKey(((BrowserEntry)this.browserMap.get(entry.getValue())).getFamily())) continue;
            Pattern pattern = new Pattern((String)entry.getKey(), 5);
            this.compiledBrowserRegMap.put(pattern, (Long)entry.getValue());
        }
    }
}

