/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.java;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.util.Map;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IScriptEvaluator;

public class JavaExecutor
extends ScriptExecutor {
    private final Map<String, IScriptEvaluator> compiledScriptMap = new CopyOnWriteHashMap();

    public void load(String nodeId, String script) {
        try {
            IScriptEvaluator se = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).newScriptEvaluator();
            se.setTargetVersion(8);
            se.setReturnType(Object.class);
            se.setParameters(new String[]{"_meta"}, new Class[]{ScriptExecuteWrap.class});
            se.cook(this.convertScript(script));
            this.compiledScriptMap.put(nodeId, se);
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}],error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    public Object executeScript(ScriptExecuteWrap wrap) throws Exception {
        if (!this.compiledScriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        IScriptEvaluator se = this.compiledScriptMap.get(wrap.getNodeId());
        return se.evaluate(new Object[]{wrap});
    }

    public void cleanCache() {
        this.compiledScriptMap.clear();
    }

    public ScriptTypeEnum scriptType() {
        return ScriptTypeEnum.JAVA;
    }

    private String convertScript(String script) {
        String script1 = script.replaceAll("public class", "class").replaceAll("private class", "class").replaceAll("protected class", "class");
        String className = ReUtil.getGroup1((String)"class\\s+(\\w+)\\s+implements", (CharSequence)script1);
        if (StrUtil.isBlank((CharSequence)className)) {
            throw new RuntimeException("cannot find class defined");
        }
        return "import com.yomahub.liteflow.script.body.JaninoCommonScriptBody;\n" + script1 + "\n" + StrUtil.format((CharSequence)"{} item = new {}();\n", (Object[])new Object[]{className, className}) + "if (item instanceof JaninoCommonScriptBody){item.body(_meta);return null;}else{return item.body(_meta);}";
    }
}

