/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.http;

import com.xingyuv.http.config.HttpConfig;
import com.xingyuv.http.exception.SimpleHttpException;
import com.xingyuv.http.support.AbstractHttp;
import com.xingyuv.http.support.Http;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.http.support.SimpleHttpResponse;
import com.xingyuv.http.support.hutool.HutoolImpl;
import com.xingyuv.http.support.java11.HttpClientImpl;
import com.xingyuv.http.support.okhttp3.OkHttp3Impl;
import com.xingyuv.http.util.ClassUtil;
import java.util.Map;

public final class HttpUtil {
    private static AbstractHttp proxy;

    private static void selectHttpProxy() {
        AbstractHttp defaultProxy = null;
        ClassLoader classLoader = HttpUtil.class.getClassLoader();
        if (null == defaultProxy && ClassUtil.isPresent("okhttp3.OkHttpClient", classLoader)) {
            defaultProxy = HttpUtil.getHttpProxy(OkHttp3Impl.class);
        }
        if (null == defaultProxy && ClassUtil.isPresent("org.apache.http.impl.client.HttpClients", classLoader)) {
            defaultProxy = HttpUtil.getHttpProxy(com.xingyuv.http.support.httpclient.HttpClientImpl.class);
        }
        if (null == defaultProxy && ClassUtil.isPresent("cn.hutool.http.HttpRequest", classLoader)) {
            defaultProxy = HttpUtil.getHttpProxy(HutoolImpl.class);
        }
        if (null == defaultProxy && ClassUtil.isPresent("java.net.http.HttpClient", classLoader)) {
            defaultProxy = HttpUtil.getHttpProxy(HttpClientImpl.class);
        }
        if (defaultProxy == null) {
            throw new SimpleHttpException("Has no HttpImpl defined in environment!");
        }
        proxy = defaultProxy;
    }

    private static <T extends AbstractHttp> AbstractHttp getHttpProxy(Class<T> clazz) {
        try {
            return (AbstractHttp)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void setHttp(AbstractHttp http) {
        proxy = http;
    }

    private static void checkHttpNotNull(Http proxy) {
        if (null == proxy) {
            HttpUtil.selectHttpProxy();
        }
    }

    public static void setConfig(HttpConfig httpConfig) {
        HttpUtil.checkHttpNotNull(proxy);
        if (null == httpConfig) {
            httpConfig = HttpConfig.builder().timeout(3000).build();
        }
        proxy.setHttpConfig(httpConfig);
    }

    public static SimpleHttpResponse get(String url) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.get(url);
    }

    public static SimpleHttpResponse get(String url, Map<String, String> params, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.get(url, params, encode);
    }

    public static SimpleHttpResponse get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.get(url, params, header, encode);
    }

    public static SimpleHttpResponse post(String url) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url);
    }

    public static SimpleHttpResponse post(String url, String data) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, data);
    }

    public static SimpleHttpResponse post(String url, String data, HttpHeader header) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, data, header);
    }

    public static SimpleHttpResponse post(String url, Map<String, String> params, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, params, encode);
    }

    public static SimpleHttpResponse post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpUtil.checkHttpNotNull(proxy);
        return proxy.post(url, params, header, encode);
    }

    private HttpUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

