/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.library.plantuml.Alias;
import com.tngtech.archunit.library.plantuml.ComponentName;
import com.tngtech.archunit.library.plantuml.IllegalDiagramException;
import com.tngtech.archunit.library.plantuml.ParsedDependency;
import com.tngtech.archunit.library.plantuml.PlantUmlComponent;
import com.tngtech.archunit.library.plantuml.PlantUmlComponents;
import com.tngtech.archunit.library.plantuml.PlantUmlDiagram;
import com.tngtech.archunit.library.plantuml.PlantUmlParseException;
import com.tngtech.archunit.library.plantuml.PlantUmlPatterns;
import com.tngtech.archunit.library.plantuml.Stereotype;
import com.tngtech.archunit.thirdparty.com.google.common.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicates;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;

class PlantUmlParser {
    private final PlantUmlPatterns plantUmlPatterns = new PlantUmlPatterns();
    private static final Function<String, Alias> TO_ALIAS = new Function<String, Alias>(){

        @Override
        public Alias apply(String value) {
            return new Alias(value);
        }
    };

    PlantUmlParser() {
    }

    PlantUmlDiagram parse(URL url) {
        Preconditions.checkNotNull(url, "URL must not be null");
        return this.createDiagram(this.readLines(url));
    }

    private PlantUmlDiagram createDiagram(List<String> rawDiagramLines) {
        List<String> diagramLines = this.filterOutComments(rawDiagramLines);
        Set<PlantUmlComponent> components = this.parseComponents(diagramLines);
        PlantUmlComponents plantUmlComponents = new PlantUmlComponents(components);
        ImmutableList<ParsedDependency> dependencies = this.parseDependencies(plantUmlComponents, diagramLines);
        return new PlantUmlDiagram.Builder(plantUmlComponents).withDependencies(dependencies).build();
    }

    private List<String> filterOutComments(List<String> lines) {
        return FluentIterable.from(lines).filter(Predicates.not(Predicates.containsPattern("^\\s*'"))).toList();
    }

    private List<String> readLines(URL url) {
        List<String> list;
        InputStreamReader in = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        try {
            list = CharStreams.readLines(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PlantUmlParseException("Could not parse diagram from " + url, e);
            }
        }
        in.close();
        return list;
    }

    private Set<PlantUmlComponent> parseComponents(List<String> plantUmlDiagramLines) {
        return this.plantUmlPatterns.filterComponents(plantUmlDiagramLines).transform(this.toPlantUmlComponent()).toSet();
    }

    private ImmutableList<ParsedDependency> parseDependencies(PlantUmlComponents plantUmlComponents, List<String> plantUmlDiagramLines) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (PlantUmlPatterns.PlantUmlDependencyMatcher matcher : this.plantUmlPatterns.matchDependencies(plantUmlDiagramLines)) {
            PlantUmlComponent origin = this.findComponentMatching(plantUmlComponents, matcher.matchOrigin());
            PlantUmlComponent target = this.findComponentMatching(plantUmlComponents, matcher.matchTarget());
            result.add(new ParsedDependency(origin.getIdentifier(), target.getIdentifier()));
        }
        return result.build();
    }

    private Function<String, PlantUmlComponent> toPlantUmlComponent() {
        return new Function<String, PlantUmlComponent>(){

            @Override
            public PlantUmlComponent apply(String input) {
                return PlantUmlParser.this.createNewComponent(input);
            }
        };
    }

    private PlantUmlComponent createNewComponent(String input) {
        PlantUmlPatterns.PlantUmlComponentMatcher matcher = this.plantUmlPatterns.matchComponent(input);
        ComponentName componentName = new ComponentName(matcher.matchComponentName());
        ImmutableSet<Stereotype> immutableStereotypes = this.identifyStereotypes(matcher, componentName);
        Optional<Alias> alias = Optional.ofNullable(matcher.matchAlias().transform(TO_ALIAS).orNull());
        return new PlantUmlComponent.Builder().withComponentName(componentName).withStereotypes(immutableStereotypes).withAlias(alias).build();
    }

    private ImmutableSet<Stereotype> identifyStereotypes(PlantUmlPatterns.PlantUmlComponentMatcher matcher, ComponentName componentName) {
        ImmutableSet.Builder stereotypes = ImmutableSet.builder();
        for (String stereotype : matcher.matchStereoTypes()) {
            stereotypes.add(new Stereotype(stereotype));
        }
        ImmutableCollection result = stereotypes.build();
        if (result.isEmpty()) {
            throw new IllegalDiagramException(String.format("Components must include at least one stereotype specifying the package identifier(<<..>>), but component '%s' does not", componentName.asString()), new Object[0]);
        }
        return result;
    }

    private PlantUmlComponent findComponentMatching(PlantUmlComponents plantUmlComponents, String originOrTargetString) {
        originOrTargetString = originOrTargetString.trim().replaceAll("^\\[", "").replaceAll("]$", "");
        return plantUmlComponents.findComponentWith(originOrTargetString);
    }
}

