/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.base.PackageMatchers;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.conditions.AllDependenciesCondition;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.library.plantuml.JavaClassDiagramAssociation;
import com.tngtech.archunit.library.plantuml.PlantUmlDiagram;
import com.tngtech.archunit.library.plantuml.PlantUmlParseException;
import com.tngtech.archunit.library.plantuml.PlantUmlParser;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

public class PlantUmlArchCondition
extends ArchCondition<JavaClass> {
    private final DescribedPredicate<Dependency> ignorePredicate;
    private final JavaClassDiagramAssociation javaClassDiagramAssociation;

    private PlantUmlArchCondition(String description, DescribedPredicate<Dependency> ignorePredicate, JavaClassDiagramAssociation javaClassDiagramAssociation) {
        super(description, new Object[0]);
        this.ignorePredicate = ignorePredicate;
        this.javaClassDiagramAssociation = javaClassDiagramAssociation;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependenciesWithOrigin(DescribedPredicate<? super JavaClass> ignorePredicate) {
        return this.ignoreDependencies(Dependency.Functions.GET_ORIGIN_CLASS.is(ignorePredicate).as("ignoring dependencies with origin " + ignorePredicate.getDescription(), new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependenciesWithTarget(DescribedPredicate<? super JavaClass> ignorePredicate) {
        return this.ignoreDependencies(Dependency.Functions.GET_TARGET_CLASS.is(ignorePredicate).as("ignoring dependencies with target " + ignorePredicate.getDescription(), new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependencies(Class<?> origin, Class<?> target) {
        return this.ignoreDependencies(origin.getName(), target.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependencies(String origin, String target) {
        return this.ignoreDependencies(Dependency.Functions.GET_ORIGIN_CLASS.is(HasName.Predicates.name(origin)).and(Dependency.Functions.GET_TARGET_CLASS.is(HasName.Predicates.name(target))).as("ignoring dependencies from %s to %s", origin, target));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependencies(DescribedPredicate<? super Dependency> ignorePredicate) {
        String description = this.getDescription() + ", " + ignorePredicate.getDescription();
        return new PlantUmlArchCondition(description, this.ignorePredicate.or(ignorePredicate), this.javaClassDiagramAssociation);
    }

    @Override
    public void check(JavaClass item, ConditionEvents events) {
        if (this.allDependenciesAreIgnored(item)) {
            return;
        }
        String[] allAllowedTargets = FluentIterable.from(this.javaClassDiagramAssociation.getPackageIdentifiersFromComponentOf(item)).append((Iterable<String>)this.javaClassDiagramAssociation.getTargetPackageIdentifiers(item)).toArray(String.class);
        AllDependenciesCondition delegate = ArchConditions.onlyHaveDependenciesInAnyPackage(allAllowedTargets).ignoreDependency(this.ignorePredicate);
        ((ArchCondition)delegate).check(item, events);
    }

    private boolean allDependenciesAreIgnored(JavaClass item) {
        return FluentIterable.from(item.getDirectDependenciesFromSelf()).allMatch(Guava.toGuava(this.ignorePredicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(URL url, Configuration configuration) {
        return PlantUmlArchCondition.create(url, configuration);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(String fileName, Configuration configuration) {
        return PlantUmlArchCondition.create(PlantUmlArchCondition.toUrl(Paths.get(fileName, new String[0])), configuration);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(Path path, Configuration configuration) {
        return PlantUmlArchCondition.create(PlantUmlArchCondition.toUrl(path), configuration);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(File file, Configuration configuration) {
        return PlantUmlArchCondition.create(PlantUmlArchCondition.toUrl(file.toPath()), configuration);
    }

    private static PlantUmlArchCondition create(URL url, Configuration configuration) {
        PlantUmlDiagram diagram = new PlantUmlParser().parse(url);
        JavaClassDiagramAssociation javaClassDiagramAssociation = new JavaClassDiagramAssociation(diagram);
        DescribedPredicate<Dependency> ignorePredicate = configuration.asIgnorePredicate(javaClassDiagramAssociation);
        return new PlantUmlArchCondition(PlantUmlArchCondition.getDescription(url, ignorePredicate.getDescription()), ignorePredicate, javaClassDiagramAssociation);
    }

    private static String getDescription(URL plantUmlUrl, String ignoreDescription) {
        return String.format("adhere to PlantUML diagram <%s>%s", PlantUmlArchCondition.getFileNameOf(plantUmlUrl), ignoreDescription);
    }

    private static String getFileNameOf(URL url) {
        return new File(url.getFile()).getName();
    }

    private static URL toUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new PlantUmlParseException(e);
        }
    }

    static interface Configuration {
        public DescribedPredicate<Dependency> asIgnorePredicate(JavaClassDiagramAssociation var1);
    }

    public static final class Configurations {
        private Configurations() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static Configuration consideringAllDependencies() {
            return new Configuration(){

                @Override
                public DescribedPredicate<Dependency> asIgnorePredicate(JavaClassDiagramAssociation javaClassDiagramAssociation) {
                    return DescribedPredicate.alwaysFalse().as("", new Object[0]);
                }
            };
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static Configuration consideringOnlyDependenciesInDiagram() {
            return new Configuration(){

                @Override
                public DescribedPredicate<Dependency> asIgnorePredicate(JavaClassDiagramAssociation javaClassDiagramAssociation) {
                    return new NotContainedInDiagramPredicate(javaClassDiagramAssociation);
                }
            };
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static Configuration consideringOnlyDependenciesInAnyPackage(String packageIdentifier, String ... furtherPackageIdentifiers) {
            final ImmutableList<String> packageIdentifiers = FluentIterable.from(Collections.singleton(packageIdentifier)).append((String[])furtherPackageIdentifiers).toList();
            return new Configuration(){

                @Override
                public DescribedPredicate<Dependency> asIgnorePredicate(JavaClassDiagramAssociation javaClassDiagramAssociation) {
                    return new NotContainedInPackagesPredicate(packageIdentifiers);
                }
            };
        }

        private static class NotContainedInPackagesPredicate
        extends DescribedPredicate<Dependency> {
            private final List<String> packageIdentifiers;

            NotContainedInPackagesPredicate(List<String> packageIdentifiers) {
                super(" while ignoring dependencies outside of packages ['%s']", Joiner.on("', '").join(packageIdentifiers));
                this.packageIdentifiers = packageIdentifiers;
            }

            @Override
            public boolean apply(Dependency input) {
                return !PackageMatchers.of(this.packageIdentifiers).apply(input.getTargetClass().getPackageName());
            }
        }

        private static class NotContainedInDiagramPredicate
        extends DescribedPredicate<Dependency> {
            private final JavaClassDiagramAssociation javaClassDiagramAssociation;

            NotContainedInDiagramPredicate(JavaClassDiagramAssociation javaClassDiagramAssociation) {
                super(" while ignoring dependencies not contained in the diagram", new Object[0]);
                this.javaClassDiagramAssociation = javaClassDiagramAssociation;
            }

            @Override
            public boolean apply(Dependency input) {
                return !this.javaClassDiagramAssociation.contains(input.getTargetClass());
            }
        }
    }
}

