/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml;

import com.tngtech.archunit.base.PackageMatcher;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.library.plantuml.ComponentIntersectionException;
import com.tngtech.archunit.library.plantuml.IllegalDiagramException;
import com.tngtech.archunit.library.plantuml.PlantUmlComponent;
import com.tngtech.archunit.library.plantuml.PlantUmlDiagram;
import com.tngtech.archunit.library.plantuml.Stereotype;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

class JavaClassDiagramAssociation {
    private final Set<AssociatedComponent> components;

    JavaClassDiagramAssociation(PlantUmlDiagram diagram) {
        ImmutableSet.Builder components = ImmutableSet.builder();
        this.validateStereotypes(diagram);
        for (PlantUmlComponent component : diagram.getAllComponents()) {
            components.add(new AssociatedComponent(component));
        }
        this.components = components.build();
    }

    private void validateStereotypes(PlantUmlDiagram plantUmlDiagram) {
        HashSet<Stereotype> visited = new HashSet<Stereotype>();
        for (PlantUmlComponent component : plantUmlDiagram.getAllComponents()) {
            for (Stereotype stereotype : component.getStereotypes()) {
                if (visited.contains(stereotype)) {
                    throw new IllegalDiagramException(String.format("Stereotype '%s' should be unique", stereotype.asString()), new Object[0]);
                }
                visited.add(stereotype);
            }
        }
    }

    Set<String> getTargetPackageIdentifiers(JavaClass javaClass) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (PlantUmlComponent target : this.getComponentOf(javaClass).getDependencies()) {
            result.addAll(this.getPackageIdentifiersFromComponentOf(target));
        }
        return result.build();
    }

    Set<String> getPackageIdentifiersFromComponentOf(JavaClass javaClass) {
        return this.getPackageIdentifiersFromComponentOf(this.getComponentOf(javaClass));
    }

    private Set<String> getPackageIdentifiersFromComponentOf(PlantUmlComponent component) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Stereotype stereotype : component.getStereotypes()) {
            result.add(stereotype.asString());
        }
        return result.build();
    }

    private PlantUmlComponent getComponentOf(JavaClass javaClass) {
        Set<PlantUmlComponent> associatedComponents = this.getAssociatedComponents(javaClass);
        if (associatedComponents.size() > 1) {
            throw new ComponentIntersectionException(String.format("Class %s may not be contained in more than one component, but is contained in [%s]", javaClass.getName(), Joiner.on(", ").join(this.getComponentNames(associatedComponents))));
        }
        if (associatedComponents.isEmpty()) {
            throw new IllegalStateException(String.format("Class %s is not contained in any component", javaClass.getName()));
        }
        return Iterables.getOnlyElement(associatedComponents);
    }

    boolean contains(JavaClass javaClass) {
        return !this.getAssociatedComponents(javaClass).isEmpty();
    }

    private Set<PlantUmlComponent> getAssociatedComponents(JavaClass javaClass) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AssociatedComponent component : this.components) {
            if (!component.contains(javaClass)) continue;
            result.add(component.asPlantUmlComponent());
        }
        return result.build();
    }

    private Set<String> getComponentNames(Set<PlantUmlComponent> associatedComponents) {
        TreeSet<String> associatedComponentNames = new TreeSet<String>();
        for (PlantUmlComponent associatedComponent : associatedComponents) {
            associatedComponentNames.add(associatedComponent.getComponentName().asString());
        }
        return associatedComponentNames;
    }

    private static class AssociatedComponent {
        private final PlantUmlComponent component;
        private final Set<PackageMatcher> packageMatchers;

        private AssociatedComponent(PlantUmlComponent component) {
            this.component = component;
            ImmutableSet.Builder packageMatchers = ImmutableSet.builder();
            for (Stereotype stereotype : component.getStereotypes()) {
                packageMatchers.add(PackageMatcher.of(stereotype.asString()));
            }
            this.packageMatchers = packageMatchers.build();
        }

        private boolean contains(JavaClass javaClass) {
            for (PackageMatcher packageMatcher : this.packageMatchers) {
                if (!packageMatcher.matches(javaClass.getPackageName())) continue;
                return true;
            }
            return false;
        }

        PlantUmlComponent asPlantUmlComponent() {
            return this.component;
        }
    }
}

