/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Predicate;
import com.tngtech.archunit.library.metrics.MetricsComponent;
import com.tngtech.archunit.library.metrics.MetricsComponents;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.Collection;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class VisibilityMetrics {
    private final ImmutableMap<String, ComponentVisibility> relativeVisibilityByComponentIdentifier;
    private final double averageRelativeVisibility;
    private final double globalRelativeVisibility;

    <T> VisibilityMetrics(MetricsComponents<T> components, Predicate<? super T> isVisible) {
        ImmutableMap.Builder<String, ComponentVisibility> relativeVisibilityByComponentIdentifierBuilder = ImmutableMap.builder();
        for (MetricsComponent metricsComponent : components) {
            relativeVisibilityByComponentIdentifierBuilder.put(metricsComponent.getIdentifier(), new ComponentVisibility(metricsComponent, isVisible));
        }
        this.relativeVisibilityByComponentIdentifier = relativeVisibilityByComponentIdentifierBuilder.build();
        this.averageRelativeVisibility = VisibilityMetrics.calculateAverageRelativeVisibility(this.relativeVisibilityByComponentIdentifier.values());
        this.globalRelativeVisibility = VisibilityMetrics.calculateGlobalRelativeVisibility(this.relativeVisibilityByComponentIdentifier.values());
    }

    private static double calculateAverageRelativeVisibility(Collection<ComponentVisibility> componentVisibilities) {
        double sum = 0.0;
        for (ComponentVisibility componentVisibility : componentVisibilities) {
            sum += componentVisibility.relativeVisibility;
        }
        return sum / (double)componentVisibilities.size();
    }

    private static double calculateGlobalRelativeVisibility(Collection<ComponentVisibility> componentVisibilities) {
        double numberOfVisibleElements = 0.0;
        double numberOfAllElements = 0.0;
        for (ComponentVisibility componentVisibility : componentVisibilities) {
            numberOfVisibleElements += (double)componentVisibility.numberOfVisibleElements;
            numberOfAllElements += (double)componentVisibility.numberOfAllElements;
        }
        return numberOfVisibleElements / numberOfAllElements;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getRelativeVisibility(String componentIdentifier) {
        this.checkComponentExists(componentIdentifier);
        return this.relativeVisibilityByComponentIdentifier.get((Object)componentIdentifier).relativeVisibility;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getAverageRelativeVisibility() {
        return this.averageRelativeVisibility;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getGlobalRelativeVisibility() {
        return this.globalRelativeVisibility;
    }

    private void checkComponentExists(String componentIdentifier) {
        Preconditions.checkArgument(this.relativeVisibilityByComponentIdentifier.containsKey(componentIdentifier), "Unknown component with identifier '" + componentIdentifier + "'");
    }

    private static class ComponentVisibility {
        final int numberOfVisibleElements;
        final int numberOfAllElements;
        final double relativeVisibility;

        <T> ComponentVisibility(MetricsComponent<T> component, Predicate<? super T> isVisible) {
            int numberOfVisibleElements = 0;
            for (Object element : component) {
                if (!isVisible.apply(element)) continue;
                ++numberOfVisibleElements;
            }
            this.numberOfVisibleElements = numberOfVisibleElements;
            this.numberOfAllElements = component.size();
            this.relativeVisibility = (double)numberOfVisibleElements / (double)this.numberOfAllElements;
        }
    }
}

