/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.library.metrics.MetricsComponent;
import com.tngtech.archunit.library.metrics.MetricsComponentDependencyGraph;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class LakosMetrics {
    private final int cumulativeComponentDependency;
    private final double averageComponentDependency;
    private final double relativeAverageComponentDependency;
    private final double normalizedCumulativeComponentDependency;

    <T> LakosMetrics(Collection<MetricsComponent<T>> components, Function<T, Collection<T>> getDependencies) {
        int cumulativeComponentDependency = 0;
        MetricsComponentDependencyGraph<T> graph = MetricsComponentDependencyGraph.of(components, getDependencies);
        for (MetricsComponent<T> component : components) {
            cumulativeComponentDependency += 1 + this.getNumberOfTransitiveDependencies(graph, component);
        }
        this.cumulativeComponentDependency = cumulativeComponentDependency;
        this.averageComponentDependency = (double)cumulativeComponentDependency / (double)components.size();
        this.relativeAverageComponentDependency = this.averageComponentDependency / (double)components.size();
        this.normalizedCumulativeComponentDependency = (double)cumulativeComponentDependency / (double)this.calculateCumulativeComponentDependencyOfBinaryTree(components.size());
    }

    private <T> int getNumberOfTransitiveDependencies(MetricsComponentDependencyGraph<T> graph, MetricsComponent<T> component) {
        Sets.SetView<MetricsComponent<T>> transitiveDependenciesWithoutSelf = Sets.difference(graph.getTransitiveDependenciesOf(component), Collections.singleton(component));
        return transitiveDependenciesWithoutSelf.size();
    }

    private int calculateCumulativeComponentDependencyOfBinaryTree(int treeSize) {
        int ccdOfBinaryTree = 0;
        int level = 1;
        int maxNodesUpToCurrentLevel = 1;
        for (int currentNode = 1; currentNode <= treeSize; ++currentNode) {
            if (currentNode > maxNodesUpToCurrentLevel) {
                maxNodesUpToCurrentLevel = (int)((double)maxNodesUpToCurrentLevel + Math.pow(2.0, ++level - 1));
            }
            ccdOfBinaryTree += level;
        }
        return ccdOfBinaryTree;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getCumulativeComponentDependency() {
        return this.cumulativeComponentDependency;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getAverageComponentDependency() {
        return this.averageComponentDependency;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getRelativeAverageComponentDependency() {
        return this.relativeAverageComponentDependency;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getNormalizedCumulativeComponentDependency() {
        return this.normalizedCumulativeComponentDependency;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("cumulativeComponentDependency", this.cumulativeComponentDependency).add("averageComponentDependency", this.averageComponentDependency).add("relativeAverageComponentDependency", this.relativeAverageComponentDependency).add("normalizedCumulativeComponentDependency", this.normalizedCumulativeComponentDependency).toString();
    }
}

