/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.base.Predicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.library.metrics.ComponentDependencyMetrics;
import com.tngtech.archunit.library.metrics.LakosMetrics;
import com.tngtech.archunit.library.metrics.MetricsComponents;
import com.tngtech.archunit.library.metrics.VisibilityMetrics;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import java.util.Collection;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ArchitectureMetrics {
    private static final Function<JavaClass, Collection<JavaClass>> GET_JAVA_CLASS_DEPENDENCIES = new Function<JavaClass, Collection<JavaClass>>(){

        @Override
        public Collection<JavaClass> apply(JavaClass javaClass) {
            return FluentIterable.from(javaClass.getDirectDependenciesFromSelf()).transform(Guava.toGuava(Dependency.Functions.GET_TARGET_CLASS)).toSet();
        }
    };

    private ArchitectureMetrics() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static LakosMetrics lakosMetrics(MetricsComponents<JavaClass> components) {
        return ArchitectureMetrics.lakosMetrics(components, GET_JAVA_CLASS_DEPENDENCIES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> LakosMetrics lakosMetrics(MetricsComponents<T> components, Function<T, Collection<T>> getDependencies) {
        return new LakosMetrics(components, getDependencies);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ComponentDependencyMetrics componentDependencyMetrics(MetricsComponents<JavaClass> components) {
        return new ComponentDependencyMetrics(components, GET_JAVA_CLASS_DEPENDENCIES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static VisibilityMetrics visibilityMetrics(MetricsComponents<JavaClass> components) {
        return ArchitectureMetrics.visibilityMetrics(components, HasModifiers.Predicates.modifier(JavaModifier.PUBLIC));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> VisibilityMetrics visibilityMetrics(MetricsComponents<T> components, Predicate<? super T> isVisible) {
        return new VisibilityMetrics(components, isVisible);
    }
}

