/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.freeze;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Predicate;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.library.freeze.ViolationLineMatcher;
import com.tngtech.archunit.library.freeze.ViolationLineMatcherFactory;
import com.tngtech.archunit.library.freeze.ViolationStore;
import com.tngtech.archunit.library.freeze.ViolationStoreFactory;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class FreezingArchRule
implements ArchRule {
    private static final Logger log = LoggerFactory.getLogger(FreezingArchRule.class);
    private static final String FREEZE_REFREEZE_PROPERTY_NAME = "freeze.refreeze";
    private final ArchRule delegate;
    private final ViolationStoreLineBreakAdapter store;
    private final ViolationLineMatcher matcher;

    private FreezingArchRule(ArchRule delegate, ViolationStore store, ViolationLineMatcher matcher) {
        this(delegate, new ViolationStoreLineBreakAdapter(store), matcher);
    }

    private FreezingArchRule(ArchRule delegate, ViolationStoreLineBreakAdapter store, ViolationLineMatcher matcher) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.store = store;
        this.matcher = Preconditions.checkNotNull(matcher);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void check(JavaClasses classes) {
        ArchRule.Assertions.check(this, classes);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FreezingArchRule because(String reason) {
        return new FreezingArchRule(this.delegate.because(reason), this.store, this.matcher);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FreezingArchRule as(String newDescription) {
        return new FreezingArchRule((ArchRule)this.delegate.as(newDescription), this.store, this.matcher);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult evaluate(JavaClasses classes) {
        this.store.initialize(ArchConfiguration.get().getSubProperties("freeze.store"));
        EvaluationResultLineBreakAdapter result = new EvaluationResultLineBreakAdapter(this.delegate.evaluate(classes));
        if (!this.store.contains(this.delegate) || this.refreezeViolations()) {
            return this.storeViolationsAndReturnSuccess(result);
        }
        return this.removeObsoleteViolationsFromStoreAndReturnNewViolations(result);
    }

    private boolean refreezeViolations() {
        String configuredRefreeze = ArchConfiguration.get().getPropertyOrDefault(FREEZE_REFREEZE_PROPERTY_NAME, Boolean.FALSE.toString());
        return Boolean.parseBoolean(configuredRefreeze);
    }

    private EvaluationResult storeViolationsAndReturnSuccess(EvaluationResultLineBreakAdapter result) {
        log.debug("No results present for rule '{}'. Freezing rule result...", (Object)this.delegate.getDescription());
        this.store.save(this.delegate, result.getViolations());
        return new EvaluationResult(this.delegate, result.getPriority());
    }

    private EvaluationResult removeObsoleteViolationsFromStoreAndReturnNewViolations(EvaluationResultLineBreakAdapter result) {
        log.debug("Found frozen result for rule '{}'", (Object)this.delegate.getDescription());
        List<String> knownViolations = this.store.getViolations(this.delegate);
        CategorizedViolations categorizedViolations = new CategorizedViolations(this.matcher, result, knownViolations);
        this.removeObsoleteViolationsFromStore(categorizedViolations);
        return this.filterOutKnownViolations(result, categorizedViolations.getKnownActualViolations());
    }

    private void removeObsoleteViolationsFromStore(CategorizedViolations categorizedViolations) {
        List<String> solvedViolations = categorizedViolations.getStoredSolvedViolations();
        log.debug("Removing {} obsolete violations from store: {}", (Object)solvedViolations.size(), solvedViolations);
        if (!solvedViolations.isEmpty()) {
            this.store.save(this.delegate, categorizedViolations.getStoredUnsolvedViolations());
        }
    }

    private EvaluationResult filterOutKnownViolations(EvaluationResultLineBreakAdapter result, final Set<String> knownActualViolations) {
        log.debug("Filtering out known violations: {}", knownActualViolations);
        return result.filterDescriptionsMatching(new Predicate<String>(){

            @Override
            public boolean apply(String violation) {
                return !knownActualViolations.contains(violation);
            }
        });
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FreezingArchRule persistIn(ViolationStore store) {
        return new FreezingArchRule(this.delegate, store, this.matcher);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FreezingArchRule associateViolationLinesVia(ViolationLineMatcher matcher) {
        return new FreezingArchRule(this.delegate, this.store, matcher);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.delegate + "}";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static FreezingArchRule freeze(ArchRule rule) {
        return new FreezingArchRule(rule, ViolationStoreFactory.create(), ViolationLineMatcherFactory.create());
    }

    static String ensureUnixLineBreaks(String string) {
        return string.replaceAll("\r\n", "\n");
    }

    private static List<String> ensureUnixLineBreaks(List<String> strings) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : strings) {
            result.add(FreezingArchRule.ensureUnixLineBreaks(string));
        }
        return result;
    }

    private static class ViolationStoreLineBreakAdapter {
        private final ViolationStore store;

        ViolationStoreLineBreakAdapter(ViolationStore store) {
            this.store = Preconditions.checkNotNull(store);
        }

        void initialize(Properties properties) {
            this.store.initialize(properties);
        }

        boolean contains(ArchRule rule) {
            return this.store.contains(rule);
        }

        List<String> getViolations(ArchRule rule) {
            return FreezingArchRule.ensureUnixLineBreaks(this.store.getViolations(rule));
        }

        void save(ArchRule rule, List<String> violations) {
            this.store.save(rule, FreezingArchRule.ensureUnixLineBreaks(violations));
        }
    }

    private static class EvaluationResultLineBreakAdapter {
        private final EvaluationResult result;

        private EvaluationResultLineBreakAdapter(EvaluationResult result) {
            this.result = Preconditions.checkNotNull(result);
        }

        List<String> getViolations() {
            return FreezingArchRule.ensureUnixLineBreaks(this.result.getFailureReport().getDetails());
        }

        Priority getPriority() {
            return this.result.getPriority();
        }

        EvaluationResult filterDescriptionsMatching(final Predicate<String> predicate) {
            return this.result.filterDescriptionsMatching(new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    return predicate.apply(FreezingArchRule.ensureUnixLineBreaks(input));
                }
            });
        }
    }

    private static class CategorizedViolations {
        private final Set<String> knownActualViolations = new HashSet<String>();
        private final List<String> storedSolvedViolations;
        private final List<String> storedUnsolvedViolations = new ArrayList<String>();

        CategorizedViolations(ViolationLineMatcher matcher, EvaluationResultLineBreakAdapter actualResult, List<String> storedViolations) {
            ArrayList<String> storedViolationsLeft = new ArrayList<String>(storedViolations);
            block0: for (String actualViolation : actualResult.getViolations()) {
                Iterator iterator = storedViolationsLeft.iterator();
                while (iterator.hasNext()) {
                    String storedViolation = (String)iterator.next();
                    if (!matcher.matches(actualViolation, storedViolation)) continue;
                    iterator.remove();
                    this.knownActualViolations.add(actualViolation);
                    this.storedUnsolvedViolations.add(storedViolation);
                    continue block0;
                }
            }
            this.storedSolvedViolations = new ArrayList<String>(storedViolations);
            this.storedSolvedViolations.removeAll(this.storedUnsolvedViolations);
        }

        Set<String> getKnownActualViolations() {
            return this.knownActualViolations;
        }

        List<String> getStoredSolvedViolations() {
            return this.storedSolvedViolations;
        }

        List<String> getStoredUnsolvedViolations() {
            return this.storedUnsolvedViolations;
        }
    }
}

