/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedIterable;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.base.PackageMatcher;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.properties.CanOverrideDescription;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.lang.syntax.PredicateAggregator;
import com.tngtech.archunit.library.dependencies.Slice;
import com.tngtech.archunit.library.dependencies.SliceAssignment;
import com.tngtech.archunit.library.dependencies.SliceIdentifier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Slices
implements DescribedIterable<Slice>,
CanOverrideDescription<Slices> {
    private final Iterable<Slice> slices;
    private final String description;

    private Slices(Iterable<Slice> slices) {
        this(slices, "Slices");
    }

    private Slices(Iterable<Slice> slices, String description) {
        this.slices = slices;
        this.description = description;
    }

    @Override
    public Iterator<Slice> iterator() {
        return this.slices.iterator();
    }

    @Override
    public Slices as(String description) {
        return new Slices(this.slices, description);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Slices namingSlices(String pattern) {
        ArrayList<Slice> newSlices = new ArrayList<Slice>();
        for (Slice slice : this.slices) {
            newSlices.add(slice.as(pattern));
        }
        return new Slices(newSlices, this.description);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Transformer matching(String packageIdentifier) {
        PackageMatchingSliceIdentifier sliceIdentifier = new PackageMatchingSliceIdentifier(packageIdentifier);
        String description = "slices matching " + sliceIdentifier.getDescription();
        return new Transformer(sliceIdentifier, description);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Transformer assignedFrom(SliceAssignment sliceAssignment) {
        String description = "slices assigned from " + sliceAssignment.getDescription();
        return new Transformer(sliceAssignment, description);
    }

    private static class PackageMatchingSliceIdentifier
    implements SliceAssignment {
        private final String packageIdentifier;

        private PackageMatchingSliceIdentifier(String packageIdentifier) {
            this.packageIdentifier = Preconditions.checkNotNull(packageIdentifier);
        }

        @Override
        public SliceIdentifier getIdentifierOf(JavaClass javaClass) {
            PackageMatcher matcher = PackageMatcher.of(this.packageIdentifier);
            Optional<List<String>> result = matcher.match(javaClass.getPackageName()).map(PackageMatcher.TO_GROUPS);
            List<String> parts = result.orElse(Collections.emptyList());
            return parts.isEmpty() ? SliceIdentifier.ignore() : SliceIdentifier.of(parts);
        }

        @Override
        public String getDescription() {
            return PackageMatchingSliceIdentifier.slicesMatchingDescription(this.packageIdentifier);
        }

        private static String slicesMatchingDescription(String packageIdentifier) {
            return "'" + packageIdentifier + "'";
        }
    }

    public static class Transformer
    implements ClassesTransformer<Slice> {
        private final SliceAssignment sliceAssignment;
        private final String description;
        private final Optional<String> namingPattern;
        private final SlicesPredicateAggregator predicate;

        Transformer(SliceAssignment sliceAssignment, String description) {
            this(sliceAssignment, description, new SlicesPredicateAggregator("that"));
        }

        private Transformer(SliceAssignment sliceAssignment, String description, SlicesPredicateAggregator predicate) {
            this(sliceAssignment, description, Optional.empty(), predicate);
        }

        private Transformer(SliceAssignment sliceAssignment, String description, Optional<String> namingPattern, SlicesPredicateAggregator predicate) {
            this.sliceAssignment = Preconditions.checkNotNull(sliceAssignment);
            this.description = Preconditions.checkNotNull(description);
            this.namingPattern = Preconditions.checkNotNull(namingPattern);
            this.predicate = predicate;
        }

        Transformer namingSlices(String pattern) {
            return this.namingSlices(Optional.of(pattern));
        }

        private Transformer namingSlices(Optional<String> pattern) {
            return new Transformer(this.sliceAssignment, this.description, pattern, this.predicate);
        }

        public Transformer as(String description) {
            return new Transformer(this.sliceAssignment, description, this.predicate).namingSlices(this.namingPattern);
        }

        public Slices of(JavaClasses classes) {
            return new Slices((Iterable)this.transform(classes));
        }

        public Slices transform(Iterable<Dependency> dependencies) {
            return new Slices((Iterable)this.transform(Dependency.toTargetClasses(dependencies)));
        }

        public Slices transform(JavaClasses classes) {
            Slices slices = this.createSlices(classes);
            if (this.namingPattern.isPresent()) {
                slices = slices.namingSlices(this.namingPattern.get());
            }
            if (this.predicate.isPresent()) {
                slices = new Slices((Iterable)Guava.Iterables.filter(slices, this.predicate.get()));
            }
            return slices.as(this.getDescription());
        }

        private Slices createSlices(JavaClasses classes) {
            SliceBuilders sliceBuilders = new SliceBuilders(this.sliceAssignment);
            for (JavaClass clazz : classes) {
                sliceBuilders.add(clazz);
            }
            return new Slices(sliceBuilders.build());
        }

        public Transformer that(DescribedPredicate<? super Slice> predicate) {
            String newDescription = this.predicate.joinDescription(this.getDescription(), predicate.getDescription());
            return new Transformer(this.sliceAssignment, newDescription, this.namingPattern, this.predicate.add(predicate));
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        Transformer thatANDsPredicates() {
            return new Transformer(this.sliceAssignment, this.description, this.namingPattern, this.predicate.thatANDs());
        }

        Transformer thatORsPredicates() {
            return new Transformer(this.sliceAssignment, this.description, this.namingPattern, this.predicate.thatORs());
        }
    }

    private static class SliceBuilders {
        private final Map<List<String>, Slice.Builder> sliceBuilders = new HashMap<List<String>, Slice.Builder>();
        private final SliceAssignment sliceAssignment;

        SliceBuilders(SliceAssignment sliceAssignment) {
            this.sliceAssignment = sliceAssignment;
        }

        void add(JavaClass clazz) {
            List<String> identifierParts = this.sliceAssignment.getIdentifierOf(clazz).getParts();
            if (identifierParts.isEmpty()) {
                return;
            }
            if (!this.sliceBuilders.containsKey(identifierParts)) {
                this.sliceBuilders.put(identifierParts, Slice.Builder.from(identifierParts, this.sliceAssignment));
            }
            this.sliceBuilders.get(identifierParts).addClass(clazz);
        }

        Set<Slice> build() {
            HashSet<Slice> result = new HashSet<Slice>();
            for (Slice.Builder builder : this.sliceBuilders.values()) {
                result.add(builder.build());
            }
            return result;
        }
    }

    private static class SlicesPredicateAggregator {
        private final PredicateAggregator<Slice> predicate;
        private final String descriptionJoinWord;

        SlicesPredicateAggregator(String descriptionJoinWord) {
            this(new PredicateAggregator<Slice>(), descriptionJoinWord);
        }

        private SlicesPredicateAggregator(PredicateAggregator<Slice> predicate, String descriptionJoinWord) {
            this.predicate = Preconditions.checkNotNull(predicate);
            this.descriptionJoinWord = Preconditions.checkNotNull(descriptionJoinWord);
        }

        boolean isPresent() {
            return this.predicate.isPresent();
        }

        DescribedPredicate<Slice> get() {
            return this.predicate.get();
        }

        SlicesPredicateAggregator add(DescribedPredicate<? super Slice> predicate) {
            return new SlicesPredicateAggregator(this.predicate.add(predicate), this.descriptionJoinWord);
        }

        SlicesPredicateAggregator thatANDs() {
            return new SlicesPredicateAggregator(this.predicate.thatANDs(), "and");
        }

        SlicesPredicateAggregator thatORs() {
            return new SlicesPredicateAggregator(this.predicate.thatORs(), "or");
        }

        String joinDescription(String first, String second) {
            return Joiner.on(" ").join(first, this.descriptionJoinWord, second);
        }
    }
}

