/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SliceIdentifier {
    private final List<String> parts;

    private SliceIdentifier(List<String> parts) {
        this.parts = ImmutableList.copyOf(parts);
    }

    List<String> getParts() {
        return this.parts;
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SliceIdentifier other = (SliceIdentifier)obj;
        return Objects.equals(this.parts, other.parts);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.parts;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static SliceIdentifier of(String ... parts) {
        return SliceIdentifier.of(ImmutableList.copyOf(parts));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static SliceIdentifier of(List<String> parts) {
        Preconditions.checkNotNull(parts, "Supplied parts may not be null");
        Preconditions.checkArgument(!parts.isEmpty(), "Parts of a %s must not be empty. Use %s.ignore() to ignore a %s", (Object)SliceIdentifier.class.getSimpleName(), (Object)SliceIdentifier.class.getSimpleName(), (Object)JavaClass.class.getSimpleName());
        return new SliceIdentifier(parts);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static SliceIdentifier ignore() {
        return new SliceIdentifier(Collections.emptyList());
    }
}

