/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingSet;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.CanOverrideDescription;
import com.tngtech.archunit.library.dependencies.SliceAssignment;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Slice
extends ForwardingSet<JavaClass>
implements HasDescription,
CanOverrideDescription<Slice> {
    private final SliceAssignment sliceAssignment;
    private final List<String> matchingGroups;
    private final Description description;
    private final Set<JavaClass> classes;
    private final int hashCode;

    private Slice(SliceAssignment sliceAssignment, List<String> matchingGroups, Set<JavaClass> classes) {
        this(sliceAssignment, matchingGroups, new Description("Slice " + Joiner.on(" - ").join(Slice.ascendingCaptures(matchingGroups))), classes);
    }

    private Slice(SliceAssignment sliceAssignment, List<String> matchingGroups, Description description, Set<JavaClass> classes) {
        this.sliceAssignment = sliceAssignment;
        this.matchingGroups = Preconditions.checkNotNull(matchingGroups);
        this.description = Preconditions.checkNotNull(description);
        this.classes = ImmutableSet.copyOf(classes);
        this.hashCode = matchingGroups.hashCode();
    }

    private static List<String> ascendingCaptures(List<String> matchingGroups) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= matchingGroups.size(); ++i) {
            result.add("$" + i);
        }
        return result;
    }

    @Override
    protected Set<JavaClass> delegate() {
        return this.classes;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return this.description.format(this.matchingGroups);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Slice as(String pattern) {
        return new Slice(this.sliceAssignment, this.matchingGroups, new Description(pattern), this.classes);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass javaClass : this) {
            for (Dependency dependency : javaClass.getDirectDependenciesFromSelf()) {
                if (!this.isNotAssignedToOwnSlice(dependency.getTargetClass())) continue;
                result.add(dependency);
            }
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getDependenciesToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass javaClass : this) {
            for (Dependency dependency : javaClass.getDirectDependenciesToSelf()) {
                if (!this.isNotAssignedToOwnSlice(dependency.getOriginClass())) continue;
                result.add(dependency);
            }
        }
        return result.build();
    }

    private boolean isNotAssignedToOwnSlice(JavaClass javaClass) {
        List<String> dependencyIdentifier = this.sliceAssignment.getIdentifierOf(javaClass).getParts();
        return !dependencyIdentifier.equals(this.matchingGroups);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getNamePart(int index) {
        Preconditions.checkArgument(index > 0 && index <= this.matchingGroups.size(), "Found no name part with index %d", index);
        return this.matchingGroups.get(index - 1);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        return Objects.equals(this.matchingGroups, other.matchingGroups);
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    private static class Description {
        private final String pattern;

        private Description(String pattern) {
            this.pattern = pattern;
        }

        String format(List<String> matchingGroups) {
            String result = this.pattern;
            for (int i = 1; i <= matchingGroups.size(); ++i) {
                result = result.replace("$" + i, matchingGroups.get(i - 1));
            }
            return result;
        }
    }

    static class Builder {
        private final List<String> matchingGroups;
        private final SliceAssignment sliceAssignment;
        private final Set<JavaClass> classes = new HashSet<JavaClass>();

        private Builder(List<String> matchingGroups, SliceAssignment sliceAssignment) {
            this.matchingGroups = matchingGroups;
            this.sliceAssignment = sliceAssignment;
        }

        static Builder from(List<String> matchingGroups, SliceAssignment sliceAssignment) {
            return new Builder(matchingGroups, sliceAssignment);
        }

        Builder addClass(JavaClass clazz) {
            this.classes.add(clazz);
            return this;
        }

        Slice build() {
            return new Slice(this.sliceAssignment, this.matchingGroups, this.classes);
        }
    }
}

