/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.library.dependencies.Edge;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

class Path<T, ATTACHMENT> {
    private final List<Edge<T, ATTACHMENT>> edges;

    Path() {
        this(Collections.emptyList());
    }

    Path(Path<T, ATTACHMENT> other) {
        this(other.getEdges());
    }

    Path(List<Edge<T, ATTACHMENT>> edges) {
        this.edges = new ArrayList<Edge<T, ATTACHMENT>>(edges);
        this.validateEdgesConnect();
    }

    private void validateEdgesConnect() {
        if (this.edges.isEmpty()) {
            return;
        }
        T expectedFrom = this.edges.get(0).getFrom();
        for (Edge<T, ATTACHMENT> edge : this.edges) {
            this.verifyEdgeFromMatches(expectedFrom, edge);
            expectedFrom = edge.getTo();
        }
    }

    private void verifyEdgeFromMatches(Object expectedFrom, Edge<T, ?> edge) {
        if (!expectedFrom.equals(edge.getFrom())) {
            throw new IllegalArgumentException("Edges are not connected: " + this.edges);
        }
    }

    List<Edge<T, ATTACHMENT>> getEdges() {
        return ImmutableList.copyOf(this.edges);
    }

    Set<Edge<T, ATTACHMENT>> getSetOfEdges() {
        return ImmutableSet.copyOf(this.edges);
    }

    Path<T, ATTACHMENT> append(Edge<T, ATTACHMENT> edge) {
        if (!this.edges.isEmpty()) {
            this.verifyEdgeFromMatches(Iterables.getLast(this.edges).getTo(), edge);
        }
        this.edges.add(edge);
        return this;
    }

    boolean isEmpty() {
        return this.edges.isEmpty();
    }

    T getStart() {
        if (this.edges.isEmpty()) {
            throw new NoSuchElementException("Empty path has no start");
        }
        return this.edges.get(0).getFrom();
    }

    T getEnd() {
        if (this.edges.isEmpty()) {
            throw new NoSuchElementException("Empty path has no end");
        }
        return this.edges.get(this.edges.size() - 1).getTo();
    }

    public boolean isCycle() {
        return !this.isEmpty() && this.getStart().equals(this.getEnd());
    }

    public int hashCode() {
        return Objects.hash(this.edges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Objects.equals(this.edges, other.edges);
    }

    public String toString() {
        return "Path{" + this.edgesToString() + '}';
    }

    String edgesToString() {
        return "edges=" + this.edges;
    }
}

