/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.library.dependencies.Slice;
import com.tngtech.archunit.library.dependencies.SliceCycleArchCondition;
import com.tngtech.archunit.library.dependencies.SliceDependency;
import com.tngtech.archunit.library.dependencies.SliceRule;
import com.tngtech.archunit.library.dependencies.Slices;
import com.tngtech.archunit.library.dependencies.syntax.GivenNamedSlices;
import com.tngtech.archunit.library.dependencies.syntax.GivenSlices;
import com.tngtech.archunit.library.dependencies.syntax.GivenSlicesConjunction;
import com.tngtech.archunit.library.dependencies.syntax.SlicesShould;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;

class GivenSlicesInternal
implements GivenSlices,
SlicesShould,
GivenSlicesConjunction {
    private final Priority priority;
    private final Slices.Transformer classesTransformer;

    GivenSlicesInternal(Priority priority, Slices.Transformer classesTransformer) {
        this.classesTransformer = Preconditions.checkNotNull(classesTransformer);
        this.priority = Preconditions.checkNotNull(priority);
    }

    @Override
    public ArchRule should(ArchCondition<? super Slice> condition) {
        return ArchRule.Factory.create(this.classesTransformer, condition.forSubtype(), this.priority);
    }

    @Override
    public GivenSlicesInternal that(DescribedPredicate<? super Slice> predicate) {
        return this.givenWith((Slices.Transformer)this.classesTransformer.that((DescribedPredicate)predicate));
    }

    @Override
    public GivenSlicesInternal and(DescribedPredicate<? super Slice> predicate) {
        return this.givenWith((Slices.Transformer)this.classesTransformer.thatANDsPredicates().that((DescribedPredicate)predicate));
    }

    @Override
    public GivenSlicesInternal or(DescribedPredicate<? super Slice> predicate) {
        return this.givenWith((Slices.Transformer)this.classesTransformer.thatORsPredicates().that((DescribedPredicate)predicate));
    }

    private GivenSlicesInternal givenWith(Slices.Transformer transformer) {
        return new GivenSlicesInternal(this.priority, transformer);
    }

    @Override
    public GivenSlicesInternal as(String newDescription) {
        return this.givenWith(this.classesTransformer.as(newDescription));
    }

    @Override
    public GivenNamedSlices namingSlices(String pattern) {
        return new GivenSlicesInternal(this.priority, this.classesTransformer.namingSlices(pattern));
    }

    @Override
    public SlicesShould should() {
        return this;
    }

    @Override
    public SliceRule beFreeOfCycles() {
        return new SliceRule(this.classesTransformer, this.priority, new SliceRule.ConditionFactory(){

            @Override
            public ArchCondition<Slice> create(Slices.Transformer transformer, DescribedPredicate<Dependency> predicate) {
                return new SliceCycleArchCondition(predicate);
            }
        });
    }

    @Override
    public SliceRule notDependOnEachOther() {
        return new SliceRule(this.classesTransformer, this.priority, new SliceRule.ConditionFactory(){

            @Override
            public ArchCondition<Slice> create(Slices.Transformer transformer, DescribedPredicate<Dependency> predicate) {
                return new NotDependOnEachOtherCondition(predicate, transformer);
            }
        });
    }

    private static class NotDependOnEachOtherCondition
    extends ArchCondition<Slice> {
        private final DescribedPredicate<Dependency> predicate;
        private final Slices.Transformer inputTransformer;

        NotDependOnEachOtherCondition(DescribedPredicate<Dependency> predicate, Slices.Transformer inputTransformer) {
            super("not depend on each other", new Object[0]);
            this.predicate = predicate;
            this.inputTransformer = inputTransformer;
        }

        @Override
        public void check(Slice slice, ConditionEvents events) {
            Iterable<Dependency> relevantDependencies = Guava.Iterables.filter(slice.getDependenciesFromSelf(), this.predicate);
            Slices dependencySlices = this.inputTransformer.transform(relevantDependencies);
            for (Slice dependencySlice : dependencySlices) {
                SliceDependency dependency = SliceDependency.of(slice, relevantDependencies, dependencySlice);
                events.add(SimpleConditionEvent.violated(dependency, dependency.getDescription()));
            }
        }
    }
}

