/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class Edge<T, ATTACHMENT> {
    private final T from;
    private final T to;
    private final List<ATTACHMENT> attachments;
    private final int hashCode;

    Edge(T from, T to, Collection<ATTACHMENT> attachments) {
        this.from = from;
        this.to = to;
        this.hashCode = Objects.hash(from, to);
        this.attachments = ImmutableList.copyOf(attachments);
    }

    T getFrom() {
        return this.from;
    }

    T getTo() {
        return this.to;
    }

    List<ATTACHMENT> getAttachments() {
        return this.attachments;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
    }

    public String toString() {
        return "Edge{from=" + this.from + ", to=" + this.to + ", attachments=" + this.attachments + '}';
    }
}

