/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;

class ObjectsShouldInternal<T>
implements ArchRule {
    private final Supplier<ArchRule> finishedRule = Suppliers.memoize(new FinishedRule());
    final ConditionAggregator<T> conditionAggregator;
    final ClassesTransformer<T> classesTransformer;
    final Priority priority;
    final Function<ArchCondition<T>, ArchCondition<T>> prepareCondition;

    ObjectsShouldInternal(ClassesTransformer<? extends T> classesTransformer, Priority priority, Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
        this(classesTransformer, priority, new ConditionAggregator(), prepareCondition);
    }

    ObjectsShouldInternal(ClassesTransformer<? extends T> classesTransformer, Priority priority, ArchCondition<T> condition, Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
        this(classesTransformer, priority, new ConditionAggregator<T>(condition), prepareCondition);
    }

    ObjectsShouldInternal(ClassesTransformer<? extends T> classesTransformer, Priority priority, ConditionAggregator<T> conditionAggregator, Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
        this.conditionAggregator = conditionAggregator;
        this.classesTransformer = this.getTyped(classesTransformer);
        this.priority = priority;
        this.prepareCondition = prepareCondition;
    }

    private ClassesTransformer<T> getTyped(ClassesTransformer<? extends T> classesTransformer) {
        return classesTransformer;
    }

    @Override
    public String getDescription() {
        return this.finishedRule.get().getDescription();
    }

    @Override
    public EvaluationResult evaluate(JavaClasses classes) {
        return this.finishedRule.get().evaluate(classes);
    }

    @Override
    public void check(JavaClasses classes) {
        this.finishedRule.get().check(classes);
    }

    @Override
    public ArchRule because(String reason) {
        return ArchRule.Factory.withBecause(this, reason);
    }

    @Override
    public ArchRule as(String newDescription) {
        return (ArchRule)this.finishedRule.get().as(newDescription);
    }

    public String toString() {
        return this.finishedRule.get().getDescription();
    }

    static <T> Function<ArchCondition<T>, ArchCondition<T>> prependDescription(final String prefix) {
        return new Function<ArchCondition<T>, ArchCondition<T>>(){

            @Override
            public ArchCondition<T> apply(ArchCondition<T> input) {
                return input.as(prefix + " " + input.getDescription(), new Object[0]);
            }
        };
    }

    static class ConditionAggregator<T> {
        private final Optional<ArchCondition<T>> condition;
        private final AddMode<T> addMode;

        ConditionAggregator() {
            this(Optional.empty(), AddMode.and());
        }

        ConditionAggregator(ArchCondition<T> condition) {
            this(Optional.of(condition), AddMode.and());
        }

        private ConditionAggregator(Optional<ArchCondition<T>> condition, AddMode<T> addMode) {
            this.condition = condition;
            this.addMode = addMode;
        }

        ArchCondition<T> getCondition() {
            Preconditions.checkState(this.condition.isPresent(), "No condition was added to this rule, this is most likely a bug within the syntax");
            return this.condition.get();
        }

        ArchCondition<T> add(ArchCondition<? super T> other) {
            return this.addMode.apply(this.condition, other);
        }

        ConditionAggregator<T> thatORsWith(Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
            return new ConditionAggregator<T>(this.condition, AddMode.or(prepareCondition));
        }

        ConditionAggregator<T> thatANDsWith(Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
            return new ConditionAggregator<T>(this.condition, AddMode.and(prepareCondition));
        }
    }

    private class FinishedRule
    implements Supplier<ArchRule> {
        private FinishedRule() {
        }

        @Override
        public ArchRule get() {
            return ArchRule.Factory.create(ObjectsShouldInternal.this.classesTransformer, this.createCondition(), ObjectsShouldInternal.this.priority);
        }

        private ArchCondition<T> createCondition() {
            return ObjectsShouldInternal.this.prepareCondition.apply(ObjectsShouldInternal.this.conditionAggregator.getCondition());
        }
    }

    private static abstract class AddMode<T> {
        private AddMode() {
        }

        static <T> AddMode<T> and() {
            return AddMode.and(Function.Functions.identity());
        }

        static <T> AddMode<T> and(final Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
            return new AddMode<T>(){

                @Override
                ArchCondition<T> apply(Optional<ArchCondition<T>> first, ArchCondition<? super T> other) {
                    ArchCondition second = (ArchCondition)prepareCondition.apply(other.forSubtype());
                    return first.isPresent() ? first.get().and(second) : second;
                }
            };
        }

        static <T> AddMode<T> or(final Function<ArchCondition<T>, ArchCondition<T>> prepareCondition) {
            return new AddMode<T>(){

                @Override
                ArchCondition<T> apply(Optional<ArchCondition<T>> first, ArchCondition<? super T> other) {
                    ArchCondition second = (ArchCondition)prepareCondition.apply(other.forSubtype());
                    return first.isPresent() ? first.get().or(second) : second;
                }
            };
        }

        abstract ArchCondition<T> apply(Optional<ArchCondition<T>> var1, ArchCondition<? super T> var2);
    }
}

