/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.AbstractGivenMembersInternal;
import com.tngtech.archunit.lang.syntax.AbstractGivenObjects;
import com.tngtech.archunit.lang.syntax.MembersDeclaredInClassesThat;
import com.tngtech.archunit.lang.syntax.PredicateAggregator;
import com.tngtech.archunit.lang.syntax.SyntaxPredicates;
import com.tngtech.archunit.lang.syntax.elements.ClassesThat;
import com.tngtech.archunit.lang.syntax.elements.MembersThat;
import java.lang.annotation.Annotation;

class MembersThatInternal<MEMBER extends JavaMember, CONJUNCTION extends AbstractGivenMembersInternal<MEMBER, CONJUNCTION>>
implements MembersThat<CONJUNCTION> {
    final CONJUNCTION givenMembers;
    final PredicateAggregator<MEMBER> currentPredicate;

    MembersThatInternal(CONJUNCTION givenMembers, PredicateAggregator<MEMBER> currentPredicate) {
        this.givenMembers = givenMembers;
        this.currentPredicate = currentPredicate;
    }

    @Override
    public CONJUNCTION haveName(String name) {
        return this.givenWith(ArchPredicates.have(HasName.Predicates.name(name)));
    }

    @Override
    public CONJUNCTION doNotHaveName(String name) {
        return this.givenWith(DescribedPredicate.doNot(ArchPredicates.have(HasName.Predicates.name(name))));
    }

    @Override
    public CONJUNCTION haveNameMatching(String regex) {
        return this.givenWith(ArchPredicates.have(HasName.Predicates.nameMatching(regex)));
    }

    @Override
    public CONJUNCTION haveNameNotMatching(String regex) {
        return this.givenWith(SyntaxPredicates.haveNameNotMatching(regex));
    }

    @Override
    public CONJUNCTION haveFullName(String fullName) {
        return this.givenWith(ArchPredicates.have(HasName.AndFullName.Predicates.fullName(fullName)));
    }

    @Override
    public CONJUNCTION doNotHaveFullName(String fullName) {
        return this.givenWith(DescribedPredicate.doNot(ArchPredicates.have(HasName.AndFullName.Predicates.fullName(fullName))));
    }

    @Override
    public CONJUNCTION haveFullNameMatching(String regex) {
        return this.givenWith(ArchPredicates.have(HasName.AndFullName.Predicates.fullNameMatching(regex)));
    }

    @Override
    public CONJUNCTION haveFullNameNotMatching(String regex) {
        return this.givenWith(ArchPredicates.have(DescribedPredicate.not(HasName.AndFullName.Predicates.fullNameMatching(regex)).as("full name not matching '%s'", regex)));
    }

    @Override
    public CONJUNCTION haveNameStartingWith(String prefix) {
        return this.givenWith(ArchPredicates.have(HasName.Predicates.nameStartingWith(prefix)));
    }

    @Override
    public CONJUNCTION haveNameNotStartingWith(String prefix) {
        return this.givenWith(ArchPredicates.have(DescribedPredicate.not(HasName.Predicates.nameStartingWith(prefix)).as("name not starting with '%s'", prefix)));
    }

    @Override
    public CONJUNCTION haveNameContaining(String infix) {
        return this.givenWith(ArchPredicates.have(HasName.Predicates.nameContaining(infix)));
    }

    @Override
    public CONJUNCTION haveNameNotContaining(String infix) {
        return this.givenWith(ArchPredicates.have(DescribedPredicate.not(HasName.Predicates.nameContaining(infix)).as("name not containing '%s'", infix)));
    }

    @Override
    public CONJUNCTION haveNameEndingWith(String suffix) {
        return this.givenWith(ArchPredicates.have(HasName.Predicates.nameEndingWith(suffix)));
    }

    @Override
    public CONJUNCTION haveNameNotEndingWith(String suffix) {
        return this.givenWith(ArchPredicates.have(DescribedPredicate.not(HasName.Predicates.nameEndingWith(suffix)).as("name not ending with '%s'", suffix)));
    }

    @Override
    public CONJUNCTION arePublic() {
        return this.givenWith(SyntaxPredicates.arePublic());
    }

    @Override
    public CONJUNCTION areNotPublic() {
        return this.givenWith(SyntaxPredicates.areNotPublic());
    }

    @Override
    public CONJUNCTION areProtected() {
        return this.givenWith(SyntaxPredicates.areProtected());
    }

    @Override
    public CONJUNCTION areNotProtected() {
        return this.givenWith(SyntaxPredicates.areNotProtected());
    }

    @Override
    public CONJUNCTION arePackagePrivate() {
        return this.givenWith(SyntaxPredicates.arePackagePrivate());
    }

    @Override
    public CONJUNCTION areNotPackagePrivate() {
        return this.givenWith(SyntaxPredicates.areNotPackagePrivate());
    }

    @Override
    public CONJUNCTION arePrivate() {
        return this.givenWith(SyntaxPredicates.arePrivate());
    }

    @Override
    public CONJUNCTION areNotPrivate() {
        return this.givenWith(SyntaxPredicates.areNotPrivate());
    }

    public CONJUNCTION areStatic() {
        return this.givenWith(SyntaxPredicates.areStatic());
    }

    public CONJUNCTION areNotStatic() {
        return this.givenWith(SyntaxPredicates.areNotStatic());
    }

    public CONJUNCTION areFinal() {
        return this.givenWith(SyntaxPredicates.areFinal());
    }

    public CONJUNCTION areNotFinal() {
        return this.givenWith(SyntaxPredicates.areNotFinal());
    }

    @Override
    public CONJUNCTION haveModifier(JavaModifier modifier) {
        return this.givenWith(SyntaxPredicates.haveModifier(modifier));
    }

    @Override
    public CONJUNCTION doNotHaveModifier(JavaModifier modifier) {
        return this.givenWith(SyntaxPredicates.doNotHaveModifier(modifier));
    }

    @Override
    public CONJUNCTION areAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.givenWith(ArchPredicates.are(CanBeAnnotated.Predicates.annotatedWith(annotationType)));
    }

    @Override
    public CONJUNCTION areNotAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(CanBeAnnotated.Predicates.annotatedWith(annotationType))));
    }

    @Override
    public CONJUNCTION areAnnotatedWith(String annotationTypeName) {
        return this.givenWith(ArchPredicates.are(CanBeAnnotated.Predicates.annotatedWith(annotationTypeName)));
    }

    @Override
    public CONJUNCTION areNotAnnotatedWith(String annotationTypeName) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(CanBeAnnotated.Predicates.annotatedWith(annotationTypeName))));
    }

    @Override
    public CONJUNCTION areAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.givenWith(ArchPredicates.are(CanBeAnnotated.Predicates.annotatedWith(predicate)));
    }

    @Override
    public CONJUNCTION areNotAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(CanBeAnnotated.Predicates.annotatedWith(predicate))));
    }

    @Override
    public CONJUNCTION areMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.givenWith(ArchPredicates.are(CanBeAnnotated.Predicates.metaAnnotatedWith(annotationType)));
    }

    @Override
    public CONJUNCTION areNotMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(CanBeAnnotated.Predicates.metaAnnotatedWith(annotationType))));
    }

    @Override
    public CONJUNCTION areMetaAnnotatedWith(String annotationTypeName) {
        return this.givenWith(ArchPredicates.are(CanBeAnnotated.Predicates.metaAnnotatedWith(annotationTypeName)));
    }

    @Override
    public CONJUNCTION areNotMetaAnnotatedWith(String annotationTypeName) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(CanBeAnnotated.Predicates.metaAnnotatedWith(annotationTypeName))));
    }

    @Override
    public CONJUNCTION areMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.givenWith(ArchPredicates.are(CanBeAnnotated.Predicates.metaAnnotatedWith(predicate)));
    }

    @Override
    public CONJUNCTION areNotMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(CanBeAnnotated.Predicates.metaAnnotatedWith(predicate))));
    }

    @Override
    public CONJUNCTION areDeclaredIn(Class<?> javaClass) {
        return this.givenWith(ArchPredicates.are(JavaMember.Predicates.declaredIn(javaClass)));
    }

    @Override
    public CONJUNCTION areNotDeclaredIn(Class<?> javaClass) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(JavaMember.Predicates.declaredIn(javaClass))));
    }

    @Override
    public CONJUNCTION areDeclaredIn(String className) {
        return this.givenWith(ArchPredicates.are(JavaMember.Predicates.declaredIn(className)));
    }

    @Override
    public CONJUNCTION areNotDeclaredIn(String className) {
        return this.givenWith(ArchPredicates.are(DescribedPredicate.not(JavaMember.Predicates.declaredIn(className))));
    }

    @Override
    public CONJUNCTION areDeclaredInClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return this.givenWith(ArchPredicates.are(this.declaredInClassesThat(predicate)));
    }

    @Override
    public ClassesThat<CONJUNCTION> areDeclaredInClassesThat() {
        return new MembersDeclaredInClassesThat(new Function<DescribedPredicate<? super JavaClass>, CONJUNCTION>(){

            @Override
            public CONJUNCTION apply(DescribedPredicate<? super JavaClass> predicate) {
                return MembersThatInternal.this.givenWith(ArchPredicates.are(MembersThatInternal.this.declaredInClassesThat(predicate)));
            }
        });
    }

    private DescribedPredicate<JavaMember> declaredInClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return JavaMember.Predicates.declaredIn(predicate).as("declared in classes that %s", predicate.getDescription());
    }

    private CONJUNCTION givenWith(DescribedPredicate<? super MEMBER> predicate) {
        return (CONJUNCTION)((AbstractGivenMembersInternal)((AbstractGivenObjects)this.givenMembers).with(this.currentPredicate.add(predicate)));
    }
}

