/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.lang.AbstractClassesTransformer;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.syntax.AbstractGivenCodeUnitsInternal;
import com.tngtech.archunit.lang.syntax.AbstractGivenMembersInternal;
import com.tngtech.archunit.lang.syntax.GivenClassInternal;
import com.tngtech.archunit.lang.syntax.GivenClassesInternal;
import com.tngtech.archunit.lang.syntax.GivenConstructorsInternal;
import com.tngtech.archunit.lang.syntax.GivenFieldsInternal;
import com.tngtech.archunit.lang.syntax.GivenMethodsInternal;
import com.tngtech.archunit.lang.syntax.GivenObjectsInternal;
import com.tngtech.archunit.lang.syntax.Transformers;
import com.tngtech.archunit.lang.syntax.elements.GivenClass;
import com.tngtech.archunit.lang.syntax.elements.GivenClasses;
import com.tngtech.archunit.lang.syntax.elements.GivenCodeUnits;
import com.tngtech.archunit.lang.syntax.elements.GivenConstructors;
import com.tngtech.archunit.lang.syntax.elements.GivenFields;
import com.tngtech.archunit.lang.syntax.elements.GivenMembers;
import com.tngtech.archunit.lang.syntax.elements.GivenMethods;
import com.tngtech.archunit.lang.syntax.elements.GivenObjects;
import java.util.Collections;

public final class ArchRuleDefinition {
    private ArchRuleDefinition() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <TYPE> GivenObjects<TYPE> all(ClassesTransformer<TYPE> classesTransformer) {
        return ArchRuleDefinition.priority(Priority.MEDIUM).all(classesTransformer);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <TYPE> GivenObjects<TYPE> no(ClassesTransformer<TYPE> classesTransformer) {
        return ArchRuleDefinition.priority(Priority.MEDIUM).no(classesTransformer);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Creator priority(Priority priority) {
        return new Creator(priority);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenClasses classes() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).classes();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenClasses noClasses() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noClasses();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenClass theClass(Class<?> clazz) {
        return ArchRuleDefinition.priority(Priority.MEDIUM).theClass(clazz);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenClass theClass(String className) {
        return ArchRuleDefinition.priority(Priority.MEDIUM).theClass(className);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenClass noClass(Class<?> clazz) {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noClass(clazz);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenClass noClass(String className) {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noClass(className);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenMembers<JavaMember> members() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).members();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenMembers<JavaMember> noMembers() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noMembers();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenFields fields() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).fields();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenFields noFields() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noFields();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenCodeUnits<JavaCodeUnit> codeUnits() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).codeUnits();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenCodeUnits<JavaCodeUnit> noCodeUnits() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noCodeUnits();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenConstructors constructors() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).constructors();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenConstructors noConstructors() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noConstructors();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenMethods methods() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).methods();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static GivenMethods noMethods() {
        return ArchRuleDefinition.priority(Priority.MEDIUM).noMethods();
    }

    private static <T> Function<ArchCondition<T>, ArchCondition<T>> negateCondition() {
        return new Function<ArchCondition<T>, ArchCondition<T>>(){

            @Override
            public ArchCondition<T> apply(ArchCondition<T> condition) {
                return ArchConditions.never(condition).as(condition.getDescription(), new Object[0]);
            }
        };
    }

    public static final class Creator {
        private final Priority priority;

        private Creator(Priority priority) {
            this.priority = priority;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenClasses classes() {
            return new GivenClassesInternal(this.priority, Transformers.classes());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenClasses noClasses() {
            return new GivenClassesInternal(this.priority, Transformers.classes().as("no " + Transformers.classes().getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenMembers<JavaMember> members() {
            return new AbstractGivenMembersInternal.GivenMembersInternal(this.priority, Transformers.members());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenMembers<JavaMember> noMembers() {
            return new AbstractGivenMembersInternal.GivenMembersInternal(this.priority, Transformers.members().as("no " + Transformers.members().getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenFields fields() {
            return new GivenFieldsInternal(this.priority, Transformers.fields());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenFields noFields() {
            return new GivenFieldsInternal(this.priority, Transformers.fields().as("no " + Transformers.fields().getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenCodeUnits<JavaCodeUnit> codeUnits() {
            return new AbstractGivenCodeUnitsInternal.GivenCodeUnitsInternal(this.priority, Transformers.codeUnits());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenCodeUnits<JavaCodeUnit> noCodeUnits() {
            return new AbstractGivenCodeUnitsInternal.GivenCodeUnitsInternal(this.priority, Transformers.codeUnits().as("no " + Transformers.codeUnits().getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenConstructors constructors() {
            return new GivenConstructorsInternal(this.priority, Transformers.constructors());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenConstructors noConstructors() {
            return new GivenConstructorsInternal(this.priority, Transformers.constructors().as("no " + Transformers.constructors().getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenMethods methods() {
            return new GivenMethodsInternal(this.priority, Transformers.methods());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenMethods noMethods() {
            return new GivenMethodsInternal(this.priority, Transformers.methods().as("no " + Transformers.methods().getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public <TYPE> GivenObjects<TYPE> all(ClassesTransformer<TYPE> classesTransformer) {
            return new GivenObjectsInternal<TYPE>(this.priority, classesTransformer);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public <TYPE> GivenObjects<TYPE> no(ClassesTransformer<TYPE> classesTransformer) {
            return new GivenObjectsInternal<TYPE>(this.priority, classesTransformer.as("no " + classesTransformer.getDescription()), ArchRuleDefinition.negateCondition());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenClass theClass(Class<?> clazz) {
            return this.theClass(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenClass theClass(String className) {
            ClassesTransformer<JavaClass> theClass = this.theClassTransformer(className);
            return new GivenClassInternal(this.priority, theClass, Function.Functions.identity());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenClass noClass(Class<?> clazz) {
            return this.noClass(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public GivenClass noClass(String className) {
            ClassesTransformer<JavaClass> noClass = this.theClassTransformer(className).as("no class " + className);
            return new GivenClassInternal(this.priority, noClass, ArchRuleDefinition.negateCondition());
        }

        private ClassesTransformer<JavaClass> theClassTransformer(final String className) {
            return new AbstractClassesTransformer<JavaClass>("the class " + className){

                @Override
                public Iterable<JavaClass> doTransform(JavaClasses classes) {
                    return Collections.singleton(classes.get(className));
                }
            };
        }
    }
}

