/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.PackageMatchers;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.thirdparty.com.google.common.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;

class JavaAccessPackagePredicate
extends DescribedPredicate<JavaAccess<?>> {
    private final Function<JavaAccess<?>, String> getPackageName;
    private final PackageMatchers packageMatchers;

    private JavaAccessPackagePredicate(String[] packageIdentifiers, Function<JavaAccess<?>, String> getPackageName) {
        super(String.format("any package ['%s']", Joiner.on("', '").join(packageIdentifiers)), new Object[0]);
        this.getPackageName = getPackageName;
        this.packageMatchers = PackageMatchers.of(packageIdentifiers);
    }

    static Creator forAccessOrigin() {
        return new Creator(new Function<JavaAccess<?>, String>(){

            @Override
            public String apply(JavaAccess<?> input) {
                return input.getOriginOwner().getPackageName();
            }
        });
    }

    static Creator forAccessTarget() {
        return new Creator(new Function<JavaAccess<?>, String>(){

            @Override
            public String apply(JavaAccess<?> input) {
                return input.getTargetOwner().getPackageName();
            }
        });
    }

    @Override
    public boolean apply(JavaAccess<?> input) {
        return this.packageMatchers.apply(this.getPackageName.apply(input));
    }

    static class Creator {
        private final Function<JavaAccess<?>, String> getPackageName;

        private Creator(Function<JavaAccess<?>, String> getPackageName) {
            this.getPackageName = getPackageName;
        }

        JavaAccessPackagePredicate matching(String ... packageIdentifiers) {
            return new JavaAccessPackagePredicate(packageIdentifiers, this.getPackageName);
        }
    }
}

