/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;

class FieldAccessCondition
extends ArchCondition<JavaFieldAccess> {
    private final DescribedPredicate<? super JavaFieldAccess> fieldAccessIdentifier;

    FieldAccessCondition(DescribedPredicate<? super JavaFieldAccess> fieldAccessIdentifier) {
        super(String.format("access field where %s", fieldAccessIdentifier.getDescription()), new Object[0]);
        this.fieldAccessIdentifier = fieldAccessIdentifier;
    }

    @Override
    public void check(JavaFieldAccess item, ConditionEvents events) {
        events.add(new SimpleConditionEvent(item, this.fieldAccessIdentifier.apply(item), item.getDescription()));
    }

    static class FieldSetAccessCondition
    extends FieldAccessCondition {
        FieldSetAccessCondition(DescribedPredicate<? super JavaFieldAccess> predicate) {
            super(predicate.forSubtype().and(JavaFieldAccess.Predicates.accessType(JavaFieldAccess.AccessType.SET)));
        }
    }

    static class FieldGetAccessCondition
    extends FieldAccessCondition {
        FieldGetAccessCondition(DescribedPredicate<? super JavaFieldAccess> predicate) {
            super(predicate.forSubtype().and(JavaFieldAccess.Predicates.accessType(JavaFieldAccess.AccessType.GET)));
        }
    }
}

