/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.conditions.ContainsOnlyCondition;
import com.tngtech.archunit.lang.conditions.EventsDescription;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class ContainAnyCondition<T>
extends ArchCondition<Collection<? extends T>> {
    private final ArchCondition<T> condition;

    ContainAnyCondition(ArchCondition<T> condition) {
        super("contain any element that " + condition.getDescription(), new Object[0]);
        this.condition = condition;
    }

    @Override
    public void check(Collection<? extends T> collection, ConditionEvents events) {
        ConditionEvents subEvents = new ConditionEvents();
        for (T element : collection) {
            this.condition.check(element, subEvents);
        }
        if (!subEvents.isEmpty()) {
            events.add(new AnyConditionEvent(collection, subEvents));
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{condition=" + this.condition + "}";
    }

    static class AnyConditionEvent
    implements ConditionEvent {
        private final Collection<?> correspondingObjects;
        private final Collection<ConditionEvent> allowed;
        private final Collection<ConditionEvent> violating;

        private AnyConditionEvent(Collection<?> correspondingObjects, ConditionEvents events) {
            this(correspondingObjects, events.getAllowed(), events.getViolating());
        }

        AnyConditionEvent(Collection<?> correspondingObjects, Collection<ConditionEvent> allowed, Collection<ConditionEvent> violating) {
            this.correspondingObjects = correspondingObjects;
            this.allowed = allowed;
            this.violating = violating;
        }

        @Override
        public boolean isViolation() {
            return this.allowed.isEmpty();
        }

        @Override
        public void addInvertedTo(ConditionEvents events) {
            events.add(new ContainsOnlyCondition.OnlyConditionEvent(this.correspondingObjects, this.violating, this.allowed));
        }

        @Override
        public List<String> getDescriptionLines() {
            return Collections.singletonList(EventsDescription.describe(this.violating));
        }

        @Override
        public void handleWith(ConditionEvent.Handler handler) {
            handler.handle(this.correspondingObjects, EventsDescription.describe(this.violating));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{correspondingObjects=" + this.correspondingObjects + ", allowed=" + this.allowed + ", violating=" + this.violating + '}';
        }
    }
}

