/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.conditions.AnyAttributeMatchesCondition;
import com.tngtech.archunit.lang.conditions.DependencyCondition;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class AnyDependencyCondition
extends AnyAttributeMatchesCondition<Dependency> {
    private final DescribedPredicate<? super Dependency> conditionPredicate;
    private final Function<JavaClass, ? extends Collection<Dependency>> javaClassToRelevantDependencies;
    private final DescribedPredicate<Dependency> ignorePredicate;

    AnyDependencyCondition(String description, DescribedPredicate<? super Dependency> predicate, Function<JavaClass, ? extends Collection<Dependency>> javaClassToRelevantDependencies) {
        this(description, predicate, javaClassToRelevantDependencies, DescribedPredicate.alwaysFalse());
    }

    private AnyDependencyCondition(String description, DescribedPredicate<? super Dependency> conditionPredicate, Function<JavaClass, ? extends Collection<Dependency>> javaClassToRelevantDependencies, DescribedPredicate<Dependency> ignorePredicate) {
        super(description, new DependencyCondition(conditionPredicate));
        this.conditionPredicate = Preconditions.checkNotNull(conditionPredicate);
        this.javaClassToRelevantDependencies = Preconditions.checkNotNull(javaClassToRelevantDependencies);
        this.ignorePredicate = Preconditions.checkNotNull(ignorePredicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public AnyDependencyCondition ignoreDependency(DescribedPredicate<? super Dependency> ignorePredicate) {
        return new AnyDependencyCondition(this.getDescription(), this.conditionPredicate, this.javaClassToRelevantDependencies, this.ignorePredicate.or(ignorePredicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public AnyDependencyCondition as(String description, Object ... args) {
        return new AnyDependencyCondition(String.format(description, args), this.conditionPredicate, this.javaClassToRelevantDependencies, this.ignorePredicate);
    }

    @Override
    Collection<Dependency> relevantAttributes(JavaClass javaClass) {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (Dependency dependency : this.javaClassToRelevantDependencies.apply(javaClass)) {
            if (this.ignorePredicate.apply(dependency)) continue;
            result.add(dependency);
        }
        return result;
    }
}

