/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class SimpleConditionEvent
implements ConditionEvent {
    private final Object correspondingObject;
    private final boolean conditionSatisfied;
    private final String message;

    public SimpleConditionEvent(Object correspondingObject, boolean conditionSatisfied, String message) {
        this.correspondingObject = correspondingObject;
        this.conditionSatisfied = conditionSatisfied;
        this.message = message;
        Preconditions.checkArgument(conditionSatisfied || !this.message.trim().isEmpty(), "Message may not be empty for violation");
    }

    @Override
    public boolean isViolation() {
        return !this.conditionSatisfied;
    }

    @Override
    public void addInvertedTo(ConditionEvents events) {
        events.add(new SimpleConditionEvent(this.correspondingObject, !this.conditionSatisfied, this.message));
    }

    @Override
    public List<String> getDescriptionLines() {
        return Collections.singletonList(this.message);
    }

    @Override
    public void handleWith(ConditionEvent.Handler handler) {
        handler.handle(Collections.singleton(this.correspondingObject), this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("correspondingObject", this.correspondingObject).add("conditionSatisfied", this.conditionSatisfied).add("message", this.message).toString();
    }

    public static ConditionEvent violated(Object correspondingObject, String message) {
        return new SimpleConditionEvent(correspondingObject, false, message);
    }

    public static ConditionEvent satisfied(Object correspondingObject, String message) {
        return new SimpleConditionEvent(correspondingObject, true, message);
    }
}

