/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Predicate;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.FailureReport;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.ViolationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class EvaluationResult {
    private final HasDescription rule;
    private final ConditionEvents events;
    private final Priority priority;

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult(HasDescription rule, Priority priority) {
        this(rule, new ConditionEvents(), priority);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult(HasDescription rule, ConditionEvents events, Priority priority) {
        this.rule = rule;
        this.events = events;
        this.priority = priority;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FailureReport getFailureReport() {
        return new FailureReport(this.rule, this.priority, this.events.getFailureMessages());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void add(EvaluationResult part) {
        for (ConditionEvent event : part.events) {
            this.events.add(event);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public void handleViolations(ViolationHandler<?> violationHandler) {
        this.events.handleViolations(violationHandler);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean hasViolation() {
        return this.events.containViolation();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Priority getPriority() {
        return this.priority;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult filterDescriptionsMatching(Predicate<String> linePredicate) {
        ConditionEvents filtered = new ConditionEvents();
        for (ConditionEvent event : this.events) {
            filtered.add(new FilteredEvent(event, linePredicate));
        }
        return new EvaluationResult(this.rule, filtered, this.priority);
    }

    private static class FilteredEvent
    implements ConditionEvent {
        private final ConditionEvent delegate;
        private final Predicate<String> linePredicate;

        private FilteredEvent(ConditionEvent delegate, Predicate<String> linePredicate) {
            this.delegate = delegate;
            this.linePredicate = linePredicate;
        }

        @Override
        public boolean isViolation() {
            return this.delegate.isViolation() && !this.getDescriptionLines().isEmpty();
        }

        @Override
        public void addInvertedTo(ConditionEvents events) {
            this.delegate.addInvertedTo(events);
        }

        @Override
        public List<String> getDescriptionLines() {
            ArrayList<String> result = new ArrayList<String>();
            for (String line : this.delegate.getDescriptionLines()) {
                if (!this.linePredicate.apply(line)) continue;
                result.add(line);
            }
            return result;
        }

        @Override
        public void handleWith(ConditionEvent.Handler handler) {
            this.delegate.handleWith(new FilteredHandler(handler, this.linePredicate));
        }
    }

    private static class FilteredHandler
    implements ConditionEvent.Handler {
        private final ConditionEvent.Handler delegate;
        private final Predicate<String> linePredicate;

        private FilteredHandler(ConditionEvent.Handler delegate, Predicate<String> linePredicate) {
            this.delegate = delegate;
            this.linePredicate = linePredicate;
        }

        @Override
        public void handle(Collection<?> correspondingObjects, String message) {
            if (this.linePredicate.apply(message)) {
                this.delegate.handle(correspondingObjects, message);
            }
        }
    }
}

