/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.FailureMessages;
import com.tngtech.archunit.lang.ViolationHandler;
import com.tngtech.archunit.thirdparty.com.google.common.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ArrayListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Ordering;
import com.tngtech.archunit.thirdparty.com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ConditionEvents
implements Iterable<ConditionEvent> {
    private final Multimap<Type, ConditionEvent> eventsByViolation = ArrayListMultimap.create();
    private Optional<String> informationAboutNumberOfViolations = Optional.empty();
    private static final Function<ConditionEvent, Iterable<String>> TO_DESCRIPTION_LINES = new Function<ConditionEvent, Iterable<String>>(){

        @Override
        public Iterable<String> apply(ConditionEvent input) {
            return input.getDescriptionLines();
        }
    };

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ConditionEvents() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void add(ConditionEvent event) {
        this.eventsByViolation.get(Type.from(event.isViolation())).add(event);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setInformationAboutNumberOfViolations(String informationAboutNumberOfViolations) {
        this.informationAboutNumberOfViolations = Optional.of(informationAboutNumberOfViolations);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Collection<ConditionEvent> getViolating() {
        return this.eventsByViolation.get(Type.VIOLATION);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Collection<ConditionEvent> getAllowed() {
        return this.eventsByViolation.get(Type.ALLOWED);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containViolation() {
        return !this.getViolating().isEmpty();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isEmpty() {
        return this.getAllowed().isEmpty() && this.getViolating().isEmpty();
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<String> getFailureDescriptionLines() {
        return this.getFailureMessages();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public FailureMessages getFailureMessages() {
        ImmutableList<String> result = FluentIterable.from(this.getViolating()).transformAndConcat(TO_DESCRIPTION_LINES).toSortedList(Ordering.natural());
        return new FailureMessages(result, this.informationAboutNumberOfViolations);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public void handleViolations(ViolationHandler<?> violationHandler) {
        ConditionEvent.Handler eventHandler = this.convertToEventHandler(violationHandler);
        for (ConditionEvent event : this.eventsByViolation.get(Type.VIOLATION)) {
            event.handleWith(eventHandler);
        }
    }

    private <T> ConditionEvent.Handler convertToEventHandler(final ViolationHandler<T> handler) {
        final Class<?> supportedElementType = TypeToken.of(handler.getClass()).resolveType(ViolationHandler.class.getTypeParameters()[0]).getRawType();
        return new ConditionEvent.Handler(){

            @Override
            public void handle(Collection<?> correspondingObjects, String message) {
                if (ConditionEvents.this.allElementTypesMatch(correspondingObjects, supportedElementType)) {
                    Collection<?> collection = correspondingObjects;
                    handler.handle(collection, message);
                }
            }
        };
    }

    private boolean allElementTypesMatch(Collection<?> violatingObjects, Class<?> supportedElementType) {
        for (Object violatingObject : violatingObjects) {
            if (supportedElementType.isInstance(violatingObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Iterator<ConditionEvent> iterator() {
        return ImmutableSet.copyOf(this.eventsByViolation.values()).iterator();
    }

    public String toString() {
        return "ConditionEvents{Allowed Events: " + this.getAllowed() + "; Violating Events: " + this.getViolating() + '}';
    }

    private static enum Type {
        ALLOWED,
        VIOLATION;


        private static Type from(boolean violation) {
            return violation ? VIOLATION : ALLOWED;
        }
    }
}

