/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.DescribedIterable;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.properties.CanOverrideDescription;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.CanBeEvaluated;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.FailureReport;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.extension.ArchUnitExtensions;
import com.tngtech.archunit.lang.extension.EvaluatedRule;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

public interface ArchRule
extends CanBeEvaluated,
CanOverrideDescription<ArchRule> {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void check(JavaClasses var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ArchRule because(String var1);

    @Internal
    public static interface Transformation {
        public ArchRule apply(ArchRule var1);

        @Internal
        public static final class Because
        implements Transformation {
            private final String reason;

            public Because(String reason) {
                this.reason = reason;
            }

            @Override
            public ArchRule apply(ArchRule rule) {
                return rule.because(this.reason);
            }

            public String toString() {
                return String.format("because '%s'", this.reason);
            }
        }

        @Internal
        public static final class As
        implements Transformation {
            private final String description;

            public As(String description) {
                this.description = description;
            }

            @Override
            public ArchRule apply(ArchRule rule) {
                return (ArchRule)rule.as(this.description);
            }

            public String toString() {
                return String.format("as '%s'", this.description);
            }
        }
    }

    @Internal
    public static class Factory {
        public static <T> ArchRule create(ClassesTransformer<T> classesTransformer, ArchCondition<T> condition, Priority priority) {
            return new SimpleArchRule(priority, classesTransformer, condition, Optional.empty());
        }

        public static ArchRule withBecause(ArchRule rule, String reason) {
            return (ArchRule)rule.as(Factory.createBecauseDescription(rule, reason));
        }

        static String createBecauseDescription(ArchRule rule, String reason) {
            return rule.getDescription() + ", because " + reason;
        }

        private static class SimpleArchRule<T>
        implements ArchRule {
            private final Priority priority;
            private final ClassesTransformer<T> classesTransformer;
            private final ArchCondition<T> condition;
            private final Optional<String> overriddenDescription;

            private SimpleArchRule(Priority priority, ClassesTransformer<T> classesTransformer, ArchCondition<T> condition, Optional<String> overriddenDescription) {
                this.priority = priority;
                this.classesTransformer = classesTransformer;
                this.condition = condition;
                this.overriddenDescription = overriddenDescription;
            }

            @Override
            public ArchRule as(String newDescription) {
                return new SimpleArchRule<T>(this.priority, this.classesTransformer, this.condition, Optional.of(newDescription));
            }

            @Override
            public void check(JavaClasses classes) {
                Assertions.check(this, classes);
            }

            @Override
            public ArchRule because(String reason) {
                return Factory.withBecause(this, reason);
            }

            @Override
            public EvaluationResult evaluate(JavaClasses classes) {
                DescribedIterable<T> allObjects = this.classesTransformer.transform(classes);
                this.condition.init(allObjects);
                ConditionEvents events = new ConditionEvents();
                for (Object object : allObjects) {
                    this.condition.check(object, events);
                }
                this.condition.finish(events);
                return new EvaluationResult(this, events, this.priority);
            }

            @Override
            public String getDescription() {
                return this.overriddenDescription.isPresent() ? this.overriddenDescription.get() : this.classesTransformer.getDescription() + " should " + this.condition.getDescription();
            }

            public String toString() {
                return this.getDescription();
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Assertions {
        private static final ArchUnitExtensions extensions = new ArchUnitExtensions();
        static final String ARCHUNIT_IGNORE_PATTERNS_FILE_NAME = "archunit_ignore_patterns.txt";
        private static final String COMMENT_LINE_PREFIX = "#";

        private Assertions() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static void check(ArchRule rule, JavaClasses classes) {
            EvaluationResult result = rule.evaluate(classes);
            extensions.dispatch(new SimpleEvaluatedRule(rule, classes, result));
            Assertions.assertNoViolation(result);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static void assertNoViolation(EvaluationResult result) {
            FailureReport report = result.getFailureReport();
            Set<Pattern> patterns = Assertions.readPatternsFrom(ARCHUNIT_IGNORE_PATTERNS_FILE_NAME);
            if (!patterns.isEmpty()) {
                report = report.filter(Assertions.notMatchedByAny(patterns));
            }
            if (!report.isEmpty()) {
                throw new AssertionError((Object)report.toString());
            }
        }

        private static Predicate<String> notMatchedByAny(final Set<Pattern> patterns) {
            return new Predicate<String>(){

                @Override
                public boolean apply(String message) {
                    for (Pattern pattern : patterns) {
                        if (!pattern.matcher(message.replaceAll("\r*\n", " ")).matches()) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        private static Set<Pattern> readPatternsFrom(String fileNameInClassPath) {
            URL ignorePatternsResource = ClassLoaders.getCurrentClassLoader(Assertions.class).getResource(fileNameInClassPath);
            if (ignorePatternsResource == null) {
                return Collections.emptySet();
            }
            try {
                return Assertions.readPatternsFrom(ignorePatternsResource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static Set<Pattern> readPatternsFrom(URL ignorePatternsResource) throws IOException {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (String line : Resources.readLines(ignorePatternsResource, StandardCharsets.UTF_8)) {
                if (line.startsWith(COMMENT_LINE_PREFIX)) continue;
                result.add(Pattern.compile(line));
            }
            return result.build();
        }

        private static class SimpleEvaluatedRule
        implements EvaluatedRule {
            private final ArchRule rule;
            private final JavaClasses importedClasses;
            private final EvaluationResult evaluationResult;

            SimpleEvaluatedRule(ArchRule rule, JavaClasses importedClasses, EvaluationResult evaluationResult) {
                this.rule = rule;
                this.importedClasses = importedClasses;
                this.evaluationResult = evaluationResult;
            }

            @Override
            public ArchRule getRule() {
                return this.rule;
            }

            @Override
            public JavaClasses getClasses() {
                return this.importedClasses;
            }

            @Override
            public EvaluationResult getResult() {
                return this.evaluationResult;
            }
        }
    }
}

