/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.ViolationHandler;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public abstract class ArchCondition<T> {
    private final String description;

    public ArchCondition(String description, Object ... args) {
        this.description = String.format(description, args);
    }

    public void init(Iterable<T> allObjectsToTest) {
    }

    public abstract void check(T var1, ConditionEvents var2);

    public void finish(ConditionEvents events) {
    }

    public ArchCondition<T> and(ArchCondition<? super T> condition) {
        return new AndCondition(this, condition.forSubtype());
    }

    public ArchCondition<T> or(ArchCondition<? super T> condition) {
        return new OrCondition(this, condition.forSubtype());
    }

    public String getDescription() {
        return this.description;
    }

    public ArchCondition<T> as(String description, Object ... args) {
        return new ArchCondition<T>(description, args){

            @Override
            public void init(Iterable<T> allObjectsToTest) {
                ArchCondition.this.init(allObjectsToTest);
            }

            @Override
            public void check(T item, ConditionEvents events) {
                ArchCondition.this.check(item, events);
            }

            @Override
            public void finish(ConditionEvents events) {
                ArchCondition.this.finish(events);
            }
        };
    }

    public String toString() {
        return this.getDescription();
    }

    public <U extends T> ArchCondition<U> forSubtype() {
        return this;
    }

    @Deprecated
    public <U extends T> ArchCondition<U> forSubType() {
        return this.forSubtype();
    }

    private static class AndCondition<T>
    extends JoinCondition<T> {
        private AndCondition(ArchCondition<T> first, ArchCondition<T> second) {
            super("and", ImmutableList.of(first, second));
        }

        @Override
        public void check(T item, ConditionEvents events) {
            events.add(new AndConditionEvent<T>(item, this.evaluateConditions(item)));
        }
    }

    private static class OrCondition<T>
    extends JoinCondition<T> {
        private OrCondition(ArchCondition<T> first, ArchCondition<T> second) {
            super("or", ImmutableList.of(first, second));
        }

        @Override
        public void check(T item, ConditionEvents events) {
            events.add(new OrConditionEvent<T>(item, this.evaluateConditions(item)));
        }
    }

    private static class OrConditionEvent<T>
    extends JoinConditionEvent<T> {
        OrConditionEvent(T item, List<ConditionWithEvents<T>> evaluatedConditions) {
            super(item, evaluatedConditions);
        }

        @Override
        public boolean isViolation() {
            for (ConditionWithEvents evaluation : this.evaluatedConditions) {
                if (evaluation.events.containViolation()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addInvertedTo(ConditionEvents events) {
            events.add(new AndConditionEvent<Object>(this.correspondingObject, this.invert(this.evaluatedConditions)));
        }

        @Override
        public List<String> getDescriptionLines() {
            return ImmutableList.of(this.createMessage());
        }

        private String createMessage() {
            return Joiner.on(" and ").join(this.getUniqueLinesOfViolations());
        }

        @Override
        public void handleWith(ConditionEvent.Handler handler) {
            handler.handle(Collections.singleton(this.correspondingObject), this.createMessage());
        }
    }

    private static class AndConditionEvent<T>
    extends JoinConditionEvent<T> {
        AndConditionEvent(T item, List<ConditionWithEvents<T>> evaluatedConditions) {
            super(item, evaluatedConditions);
        }

        @Override
        public boolean isViolation() {
            for (ConditionWithEvents evaluation : this.evaluatedConditions) {
                if (!evaluation.events.containViolation()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addInvertedTo(ConditionEvents events) {
            events.add(new OrConditionEvent<Object>(this.correspondingObject, this.invert(this.evaluatedConditions)));
        }

        @Override
        public List<String> getDescriptionLines() {
            return this.getUniqueLinesOfViolations();
        }

        @Override
        public void handleWith(final ConditionEvent.Handler handler) {
            for (ConditionWithEvents condition : this.evaluatedConditions) {
                condition.events.handleViolations(new ViolationHandler<Object>(){

                    @Override
                    public void handle(Collection<Object> violatingObjects, String message) {
                        handler.handle(violatingObjects, message);
                    }
                });
            }
        }
    }

    private static abstract class JoinConditionEvent<T>
    implements ConditionEvent {
        final T correspondingObject;
        final List<ConditionWithEvents<T>> evaluatedConditions;

        JoinConditionEvent(T correspondingObject, List<ConditionWithEvents<T>> evaluatedConditions) {
            this.correspondingObject = correspondingObject;
            this.evaluatedConditions = evaluatedConditions;
        }

        List<String> getUniqueLinesOfViolations() {
            TreeSet<String> result = new TreeSet<String>();
            for (ConditionWithEvents<T> evaluation : this.evaluatedConditions) {
                for (ConditionEvent event : ((ConditionWithEvents)evaluation).events) {
                    if (!event.isViolation()) continue;
                    result.addAll(event.getDescriptionLines());
                }
            }
            return ImmutableList.copyOf(result);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("evaluatedConditions", this.evaluatedConditions).toString();
        }

        List<ConditionWithEvents<T>> invert(List<ConditionWithEvents<T>> evaluatedConditions) {
            ArrayList<ConditionWithEvents<T>> inverted = new ArrayList<ConditionWithEvents<T>>();
            for (ConditionWithEvents<T> evaluation : evaluatedConditions) {
                inverted.add(this.invert(evaluation));
            }
            return inverted;
        }

        ConditionWithEvents<T> invert(ConditionWithEvents<T> evaluation) {
            ConditionEvents invertedEvents = new ConditionEvents();
            for (ConditionEvent event : ((ConditionWithEvents)evaluation).events) {
                event.addInvertedTo(invertedEvents);
            }
            return new ConditionWithEvents(((ConditionWithEvents)evaluation).condition, invertedEvents);
        }
    }

    private static class ConditionWithEvents<T> {
        private final ArchCondition<T> condition;
        private final ConditionEvents events;

        ConditionWithEvents(ArchCondition<T> condition, T item) {
            this(condition, ConditionWithEvents.check(condition, item));
        }

        ConditionWithEvents(ArchCondition<T> condition, ConditionEvents events) {
            this.condition = condition;
            this.events = events;
        }

        private static <T> ConditionEvents check(ArchCondition<T> condition, T item) {
            ConditionEvents events = new ConditionEvents();
            condition.check(item, events);
            return events;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("condition", this.condition).add("events", this.events).toString();
        }
    }

    private static abstract class JoinCondition<T>
    extends ArchCondition<T> {
        private final Collection<ArchCondition<T>> conditions;

        private JoinCondition(String infix, Collection<ArchCondition<T>> conditions) {
            super(JoinCondition.joinDescriptionsOf(infix, conditions), new Object[0]);
            this.conditions = conditions;
        }

        private static <T> String joinDescriptionsOf(String infix, Collection<ArchCondition<T>> conditions) {
            ArrayList<String> descriptions = new ArrayList<String>();
            for (ArchCondition<T> condition : conditions) {
                descriptions.add(condition.getDescription());
            }
            return Joiner.on(" " + infix + " ").join(descriptions);
        }

        @Override
        public void init(Iterable<T> allObjectsToTest) {
            for (ArchCondition<T> condition : this.conditions) {
                condition.init(allObjectsToTest);
            }
        }

        @Override
        public void finish(ConditionEvents events) {
            for (ArchCondition<T> condition : this.conditions) {
                condition.finish(events);
            }
        }

        List<ConditionWithEvents<T>> evaluateConditions(T item) {
            ArrayList<ConditionWithEvents<T>> evaluate = new ArrayList<ConditionWithEvents<T>>();
            for (ArchCondition<T> condition : this.conditions) {
                evaluate.add(new ConditionWithEvents<T>(condition, item));
            }
            return evaluate;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.conditions + "}";
        }
    }
}

