/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedIterable;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Guava;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ClassesTransformer;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public abstract class AbstractClassesTransformer<T>
implements ClassesTransformer<T> {
    private final String description;

    protected AbstractClassesTransformer(String description) {
        this.description = description;
    }

    @Override
    public final DescribedIterable<T> transform(JavaClasses collection) {
        return DescribedIterable.From.iterable(this.doTransform(collection), this.description);
    }

    public abstract Iterable<T> doTransform(JavaClasses var1);

    @Override
    public final ClassesTransformer<T> that(final DescribedPredicate<? super T> predicate) {
        return new AbstractClassesTransformer<T>(this.description + " that " + predicate.getDescription()){

            @Override
            public Iterable<T> doTransform(JavaClasses collection) {
                Iterable transformed = AbstractClassesTransformer.this.doTransform(collection);
                return Guava.Iterables.filter(transformed, predicate);
            }
        };
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final ClassesTransformer<T> as(String description) {
        return new AbstractClassesTransformer<T>(description){

            @Override
            public Iterable<T> doTransform(JavaClasses collection) {
                return AbstractClassesTransformer.this.doTransform(collection);
            }
        };
    }

    public String toString() {
        return ClassesTransformer.class.getSimpleName() + "{" + this.getDescription() + "}";
    }
}

