/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer.resolvers;

import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

@MayResolveTypesViaReflection(reason="This is a dedicated option to resolve further dependencies from the classpath")
public final class ClassResolverFromClasspath
implements ClassResolver {
    private ClassResolver.ClassUriImporter classUriImporter;

    @Override
    public void setClassUriImporter(ClassResolver.ClassUriImporter classUriImporter) {
        this.classUriImporter = Preconditions.checkNotNull(classUriImporter, "%s may not be null", (Object)ClassResolver.ClassUriImporter.class.getSimpleName());
    }

    @Override
    public Optional<JavaClass> tryResolve(String typeName) {
        String typeFile = typeName.replace(".", "/") + ".class";
        Optional<URI> uri = this.tryGetUriOf(typeFile);
        return uri.isPresent() ? this.classUriImporter.tryImport(uri.get()) : Optional.empty();
    }

    private Optional<URI> tryGetUriOf(String typeFile) {
        URL resource = ClassLoaders.getCurrentClassLoader(this.getClass()).getResource(typeFile);
        if (resource == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.toUri(resource));
        }
        catch (URISyntaxException e) {
            throw new ArchUnitException.LocationException(e);
        }
    }

    private URI toUri(URL resource) throws URISyntaxException {
        try {
            return resource.toURI();
        }
        catch (URISyntaxException e) {
            return new URI(resource.getProtocol(), resource.getHost(), resource.getPath(), null);
        }
    }
}

