/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.SignatureTypeArgumentProcessor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignatureTypeParameterProcessor<OWNER extends HasDescription>
extends SignatureVisitor {
    private static final Logger log = LoggerFactory.getLogger(SignatureTypeParameterProcessor.class);
    private final List<DomainBuilders.JavaTypeParameterBuilder<OWNER>> typeParameterBuilders = new ArrayList<DomainBuilders.JavaTypeParameterBuilder<OWNER>>();
    private DomainBuilders.JavaTypeParameterBuilder<OWNER> currentType;
    private DomainBuilders.JavaParameterizedTypeBuilder<OWNER> currentBound;

    SignatureTypeParameterProcessor() {
        super(589824);
    }

    List<DomainBuilders.JavaTypeParameterBuilder<OWNER>> getTypeParameterBuilders() {
        return this.typeParameterBuilders;
    }

    void addTypeParameter(String typeName) {
        this.currentType = new DomainBuilders.JavaTypeParameterBuilder(typeName);
        this.currentBound = null;
        this.typeParameterBuilders.add(this.currentType);
    }

    @Override
    public void visitClassType(String internalObjectName) {
        JavaClassDescriptor type = JavaClassDescriptorImporter.createFromAsmObjectTypeName(internalObjectName);
        log.trace("Encountered upper bound for {}: Class type {}", (Object)this.currentType.getName(), (Object)type.getFullyQualifiedClassName());
        this.currentBound = new DomainBuilders.JavaParameterizedTypeBuilder(type);
    }

    @Override
    public void visitTypeArgument() {
        log.trace("Encountered wildcard for {}", (Object)this.currentBound.getTypeName());
        this.currentBound.addTypeArgument(new SignatureTypeArgumentProcessor.NewJavaTypeCreationProcess(new DomainBuilders.JavaWildcardTypeBuilder()));
    }

    @Override
    public void visitTypeVariable(String name) {
        log.trace("Encountered upper bound for {}: Type variable {}", (Object)this.currentType.getName(), (Object)name);
        this.currentType.addBound(new SignatureTypeArgumentProcessor.ReferenceCreationProcess(name));
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        return SignatureTypeArgumentProcessor.create(wildcard, this.currentBound);
    }

    @Override
    public void visitInnerClassType(String name) {
        this.currentBound = this.currentBound.forInnerClass(name);
    }

    @Override
    public void visitEnd() {
        this.currentType.addBound(new SignatureTypeArgumentProcessor.NewJavaTypeCreationProcess<OWNER>(this.currentBound));
    }
}

