/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

class RawAccessRecord {
    final CodeUnit caller;
    final TargetInfo target;
    final int lineNumber;

    RawAccessRecord(CodeUnit caller, TargetInfo target, int lineNumber) {
        this.caller = Preconditions.checkNotNull(caller);
        this.target = Preconditions.checkNotNull(target);
        this.lineNumber = lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.caller, this.target, this.lineNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RawAccessRecord other = (RawAccessRecord)obj;
        return Objects.equals(this.caller, other.caller) && Objects.equals(this.target, other.target) && Objects.equals(this.lineNumber, other.lineNumber);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.fieldsAsString() + '}';
    }

    private String fieldsAsString() {
        return "caller=" + this.caller + ", target=" + this.target + ", lineNumber=" + this.lineNumber;
    }

    static class CodeUnit {
        private final String name;
        private final List<String> parameters;
        private final String declaringClassName;
        private final int hashCode;

        CodeUnit(String name, List<String> parameters, String declaringClassName) {
            this.name = name;
            this.parameters = parameters;
            this.declaringClassName = declaringClassName;
            this.hashCode = Objects.hash(name, parameters, declaringClassName);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        String getDeclaringClassName() {
            return this.declaringClassName;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeUnit codeUnit = (CodeUnit)o;
            return Objects.equals(this.name, codeUnit.name) && Objects.equals(this.parameters, codeUnit.parameters) && Objects.equals(this.declaringClassName, codeUnit.declaringClassName);
        }

        public String toString() {
            return "CodeUnit{name='" + this.name + '\'' + ", parameters=" + this.parameters + ", declaringClassName='" + this.declaringClassName + '\'' + '}';
        }

        public boolean is(JavaCodeUnit method) {
            return this.getName().equals(method.getName()) && this.getParameters().equals(HasName.Utils.namesOf(method.getRawParameterTypes())) && this.getDeclaringClassName().equals(method.getOwner().getName());
        }
    }

    static class TargetInfo {
        final JavaClassDescriptor owner;
        final String name;
        final String desc;

        TargetInfo(String owner, String name, String desc) {
            this.owner = JavaClassDescriptorImporter.createFromAsmObjectTypeName(owner);
            this.name = name;
            this.desc = desc;
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.name, this.desc);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TargetInfo other = (TargetInfo)obj;
            return Objects.equals(this.owner, other.owner) && Objects.equals(this.name, other.name) && Objects.equals(this.desc, other.desc);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{owner='" + this.owner.getFullyQualifiedClassName() + "', name='" + this.name + "', desc='" + this.desc + "'}";
        }
    }

    static class ForField
    extends RawAccessRecord {
        final JavaFieldAccess.AccessType accessType;

        private ForField(CodeUnit caller, TargetInfo target, int lineNumber, JavaFieldAccess.AccessType accessType) {
            super(caller, target, lineNumber);
            this.accessType = accessType;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(new Object[]{this.accessType});
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ForField other = (ForField)obj;
            return Objects.equals((Object)this.accessType, (Object)other.accessType);
        }

        static class Builder
        extends BaseBuilder<Builder> {
            private JavaFieldAccess.AccessType accessType;

            Builder() {
            }

            Builder withAccessType(JavaFieldAccess.AccessType accessType) {
                this.accessType = accessType;
                return this;
            }

            @Override
            ForField build() {
                return new ForField(this.caller, this.target, this.lineNumber, this.accessType);
            }
        }
    }

    static class BaseBuilder<SELF extends BaseBuilder<SELF>> {
        CodeUnit caller;
        TargetInfo target;
        int lineNumber = -1;

        BaseBuilder() {
        }

        SELF withCaller(CodeUnit caller) {
            this.caller = caller;
            return this.self();
        }

        SELF withTarget(TargetInfo target) {
            this.target = target;
            return this.self();
        }

        SELF withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this.self();
        }

        SELF self() {
            return (SELF)this;
        }

        RawAccessRecord build() {
            return new RawAccessRecord(this.caller, this.target, this.lineNumber);
        }
    }

    static class Builder
    extends BaseBuilder<Builder> {
        Builder() {
        }
    }
}

